/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.event;

import com.min01.unleashed.entity.UnleashedEntities;
import com.min01.unleashed.entity.model.ModelCelestialJellyfish;
import com.min01.unleashed.entity.model.ModelCelestialOrb;
import com.min01.unleashed.entity.model.ModelJellyfish;
import com.min01.unleashed.entity.renderer.CelestialBeamRenderer;
import com.min01.unleashed.entity.renderer.CelestialJellyfishRenderer;
import com.min01.unleashed.entity.renderer.CelestialOrbRenderer;
import com.min01.unleashed.entity.renderer.NoneRenderer;
import com.min01.unleashed.entity.renderer.layer.CelestialJellyfishArmorLayer;
import com.min01.unleashed.item.CelestialJellyfishUmbrellaItem;
import com.min01.unleashed.item.UnleashedItems;
import com.min01.unleashed.item.model.ModelCelestialJellyfishArmor;
import com.min01.unleashed.misc.UnleashedArmPoses;
import com.min01.unleashed.particle.CelestialExplosionParticle;
import com.min01.unleashed.particle.UnleashedParticles;
import com.min01.unleashed.shader.UnleashedShaders;
import com.min01.unleashed.world.effects.CelestialFieldDimensionSpecialEffects;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="bossesunleashed", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        UnleashedArmPoses.registerArmPoses();
        ItemProperties.register((Item)((Item)UnleashedItems.CELESTIAL_JELLYFISH_UMBRELLA.get()), (ResourceLocation)new ResourceLocation("folded"), (p_174585_, p_174586_, p_174587_, p_174588_) -> CelestialJellyfishUmbrellaItem.isUnfolded(p_174585_) ? 0.0f : 1.0f);
    }

    @SubscribeEvent
    public static void onRegisterDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(new ResourceLocation("bossesunleashed", "celestial_field"), (DimensionSpecialEffects)new CelestialFieldDimensionSpecialEffects());
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new UnleashedShaders());
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)UnleashedParticles.CELESTIAL_EXPLOSION.get(), CelestialExplosionParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelJellyfish.LAYER_LOCATION, ModelJellyfish::createBodyLayer);
        event.registerLayerDefinition(ModelCelestialJellyfish.LAYER_LOCATION, ModelCelestialJellyfish::createBodyLayer);
        event.registerLayerDefinition(ModelCelestialOrb.LAYER_LOCATION, ModelCelestialOrb::createBodyLayer);
        event.registerLayerDefinition(ModelCelestialJellyfishArmor.LAYER_LOCATION, ModelCelestialJellyfishArmor::createBodyLayer);
    }

    @SubscribeEvent
    public static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)UnleashedEntities.CELESTIAL_JELLYFISH.get(), CelestialJellyfishRenderer::new);
        event.registerEntityRenderer((EntityType)UnleashedEntities.CELESTIAL_ORB.get(), CelestialOrbRenderer::new);
        event.registerEntityRenderer((EntityType)UnleashedEntities.CELESTIAL_BEAM.get(), CelestialBeamRenderer::new);
        event.registerEntityRenderer((EntityType)UnleashedEntities.CAMERA_SHAKE.get(), NoneRenderer::new);
        event.registerEntityRenderer((EntityType)UnleashedEntities.WORMHOLE.get(), NoneRenderer::new);
        event.registerEntityRenderer((EntityType)UnleashedEntities.BLACKHOLE.get(), NoneRenderer::new);
    }

    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        Map renderers = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityRenderersEvent.AddLayers.class, (Object)event, (String)"renderers");
        renderers.values().stream().filter(LivingEntityRenderer.class::isInstance).map(LivingEntityRenderer.class::cast).forEach(t -> ClientEventHandler.addLayers(t, event.getEntityModels()));
        event.getSkins().forEach(renderer -> {
            LivingEntityRenderer skin = event.getSkin(renderer);
            ClientEventHandler.addLayers(Objects.requireNonNull(skin), event.getEntityModels());
        });
    }

    private static <T extends LivingEntity, M extends HumanoidModel<T>> void addLayers(LivingEntityRenderer<T, M> renderer, EntityModelSet model) {
        renderer.m_115326_(new CelestialJellyfishArmorLayer<T, M, HumanoidModel>(renderer, new HumanoidModel(model.m_171103_(ModelLayers.f_171164_)), new HumanoidModel(model.m_171103_(ModelLayers.f_171165_))));
    }
}

