/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.entity.renderer.layer;

import com.min01.unleashed.misc.UnleashedRenderType;
import com.min01.unleashed.util.UnleashedClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public abstract class GlowingArmorLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends HumanoidArmorLayer<T, M, A> {
    private final A innerModel;
    private final A outerModel;
    public final ResourceLocation armorLocation;
    public final ResourceLocation layerLocation;

    public GlowingArmorLayer(RenderLayerParent<T, M> renderer, A innerModel, A outerModel, String armorLocation, String layerLocation) {
        super(renderer, innerModel, outerModel, UnleashedClientUtil.MC.m_91304_());
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.armorLocation = new ResourceLocation("bossesunleashed", armorLocation);
        this.layerLocation = new ResourceLocation("bossesunleashed", layerLocation);
    }

    public void m_6494_(PoseStack poseStack, MultiBufferSource p_117097_, int p_117098_, T p_117099_, float p_117100_, float p_117101_, float p_117102_, float p_117103_, float p_117104_, float p_117105_) {
        this.m_117118_(poseStack, p_117097_, p_117099_, EquipmentSlot.CHEST, p_117098_, this.m_117078_(EquipmentSlot.CHEST));
        this.m_117118_(poseStack, p_117097_, p_117099_, EquipmentSlot.LEGS, p_117098_, this.m_117078_(EquipmentSlot.LEGS));
        this.m_117118_(poseStack, p_117097_, p_117099_, EquipmentSlot.FEET, p_117098_, this.m_117078_(EquipmentSlot.FEET));
        this.m_117118_(poseStack, p_117097_, p_117099_, EquipmentSlot.HEAD, p_117098_, this.m_117078_(EquipmentSlot.HEAD));
    }

    public abstract void m_117118_(PoseStack var1, MultiBufferSource var2, T var3, EquipmentSlot var4, int var5, A var6);

    public void render(ItemStack stack, PoseStack poseStack, MultiBufferSource p_117120_, T p_117121_, EquipmentSlot p_117122_, int p_117123_, A p_117124_) {
        ArmorItem armoritem = (ArmorItem)stack.m_41720_();
        if (armoritem.m_40402_() == p_117122_) {
            ((HumanoidModel)this.m_117386_()).m_102872_(p_117124_);
            this.m_117125_((HumanoidModel)p_117124_, p_117122_);
            Model model = this.getArmorModelHook((LivingEntity)p_117121_, stack, p_117122_, (HumanoidModel)p_117124_);
            this.renderModel(poseStack, p_117120_, p_117123_, model, 1.0f, 1.0f, 1.0f, this.armorLocation, this.layerLocation);
            if (stack.m_41790_()) {
                this.renderGlint(poseStack, p_117120_, p_117123_, model);
            }
        }
    }

    public boolean m_117128_(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    public A m_117078_(EquipmentSlot slot) {
        return this.m_117128_(slot) ? this.innerModel : this.outerModel;
    }

    public void renderGlint(PoseStack p_289673_, MultiBufferSource p_289654_, int p_289649_, Model p_289659_) {
        p_289659_.m_7695_(p_289673_, p_289654_.m_6299_(RenderType.m_110484_()), p_289649_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderModel(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Model p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource, ResourceLocation eyeResource) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)armorResource));
        p_117112_.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
        VertexConsumer eyeConsumer = bufferSource.m_6299_(UnleashedRenderType.eyesFix(eyeResource));
        p_117112_.m_7695_(poseStack, eyeConsumer, 240, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }
}

