/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.entity.renderer;

import com.min01.unleashed.entity.projectile.EntityCelestialBeam;
import com.min01.unleashed.misc.UnleashedRenderType;
import com.min01.unleashed.util.UnleashedClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CelestialBeamRenderer
extends EntityRenderer<EntityCelestialBeam> {
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 1.3f;
    private static final float BEAM_RADIUS = 1.0f;

    public CelestialBeamRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(EntityCelestialBeam p_114485_, float p_114486_, float p_114487_, PoseStack p_114488_, MultiBufferSource p_114489_, int p_114490_) {
        Vec3 collidePos = p_114485_.collidePos;
        Vec3 pos = p_114485_.m_20318_(p_114487_);
        float yaw = p_114485_.getYaw();
        float pitch = p_114485_.getPitch();
        Vec3 relativePos = collidePos.m_82546_(pos);
        float length = (float)Math.sqrt(Math.pow(relativePos.f_82479_, 2.0) + Math.pow(relativePos.f_82480_, 2.0) + Math.pow(relativePos.f_82481_, 2.0));
        int frame = 5;
        VertexConsumer consumer = p_114489_.m_6299_(UnleashedRenderType.m_110488_((ResourceLocation)this.getTextureLocation(p_114485_)));
        this.renderStart(frame, p_114488_, consumer, 0xF000F0);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, p_114488_, consumer, 0xF000F0);
        p_114488_.m_85836_();
        p_114488_.m_85837_(relativePos.f_82479_, relativePos.f_82480_, relativePos.f_82481_);
        this.renderEnd(frame, null, p_114488_, consumer, 0xF000F0);
        p_114488_.m_85849_();
    }

    private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, -1.3f, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.3f, 1.3f, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, 1.3f, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.3f, -1.3f, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderStart(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quat = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quat = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quat);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternionf sideQuat = side.m_253075_();
        sideQuat.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(sideQuat);
        matrixStackIn.m_252880_(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrixstack$entry.m_252922_();
        Matrix3f matrix3f = matrixstack$entry.m_252943_();
        float offset = 0.0f;
        this.drawVertex(matrix4f, matrix3f, builder, -1.0f, offset, 0.0f, minU, minV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.0f, length, 0.0f, minU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.0f, length, 0.0f, maxU, maxV, 1.0f, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.0f, offset, 0.0f, maxU, minV, 1.0f, packedLightIn);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        Camera camera = UnleashedClientUtil.MC.f_91063_.m_109153_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(yaw - 90.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-pitch));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(camera.m_90589_() + 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90589_() - 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(EntityCelestialBeam p_114482_) {
        return new ResourceLocation("bossesunleashed", "textures/entity/celestial_beam.png");
    }
}

