/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.entity.projectile;

import com.min01.unleashed.entity.ITrail;
import com.min01.unleashed.entity.living.EntityCelestialJellyfish;
import com.min01.unleashed.particle.UnleashedParticles;
import com.min01.unleashed.util.UnleashedUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCelestialOrb
extends ThrowableProjectile
implements ITrail {
    public static final EntityDataAccessor<Boolean> IS_TRAIL = SynchedEntityData.m_135353_(EntityCelestialOrb.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_REWIND = SynchedEntityData.m_135353_(EntityCelestialOrb.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EntityCelestialOrb.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private Vec3[] trailPositions = new Vec3[64];
    private int trailPointer = -1;

    public EntityCelestialOrb(EntityType<? extends ThrowableProjectile> p_37466_, Level p_37467_) {
        super(p_37466_, p_37467_);
        this.m_20242_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_TRAIL, (Object)false);
        this.f_19804_.m_135372_(IS_REWIND, (Object)false);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.tickTrail();
        }
        if (this.isTrail()) {
            Entity entity = this.m_19749_();
            if (entity instanceof EntityCelestialJellyfish) {
                EntityCelestialJellyfish jellyfish = (EntityCelestialJellyfish)entity;
                if (!this.isRewind()) {
                    if (jellyfish.isRewind() && jellyfish.m_6084_()) {
                        this.m_20256_(this.m_20184_().m_82490_((double)(-(this.distanceToXZ((Entity)jellyfish) * 0.05f))));
                        this.m_20256_(this.m_20184_().m_82490_((double)0.1f));
                        this.setRewind(true);
                    }
                    if (!jellyfish.isSecondPhase() && !jellyfish.m_6084_() && this.distanceToXZ((Entity)jellyfish) <= 3.0f) {
                        this.m_146870_();
                    }
                } else {
                    this.m_20256_(this.m_20184_().m_82490_((double)1.05f));
                    if (this.distanceToXZ((Entity)jellyfish) <= 3.5f) {
                        this.m_146870_();
                    }
                }
            }
            if (this.f_19797_ >= 300 || this.m_146899_()) {
                this.m_146870_();
            }
        } else {
            if (this.f_19797_ == 38) {
                this.m_216990_(SoundEvents.f_11913_);
                this.f_19853_.m_7605_((Entity)this, (byte)99);
            }
            if (this.f_19797_ >= 40) {
                List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), this::canExplode);
                list.forEach(t -> t.m_6469_(this.m_269291_().m_269036_((Entity)this, this.m_19749_()), 20.0f));
                this.m_146870_();
            }
        }
        if (this.m_19749_() == null || this.m_19749_().m_213877_()) {
            this.m_146870_();
        }
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean canExplode(Entity entity) {
        if (this.m_19749_() != null) {
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof EntityCelestialJellyfish) {
                EntityCelestialJellyfish owner = (EntityCelestialJellyfish)entity2;
                if (entity instanceof EntityCelestialJellyfish) {
                    EntityCelestialJellyfish jellyfish = (EntityCelestialJellyfish)entity;
                    if (owner.isClone() && jellyfish.isClone() && owner.getOwner() != null && jellyfish.getOwner() != null && owner.getOwner() == jellyfish.getOwner()) {
                        return false;
                    }
                    if (owner.isClone() && owner.getOwner() == jellyfish) {
                        return false;
                    }
                    if (jellyfish.isClone() && jellyfish.getOwner() == this.m_19749_()) {
                        return false;
                    }
                }
            }
            return entity != this.m_19749_() && !entity.m_7307_(this.m_19749_());
        }
        return true;
    }

    public float distanceToXZ(Entity entity) {
        float x = (float)(this.m_20185_() - entity.m_20185_());
        float z = (float)(this.m_20189_() - entity.m_20189_());
        return Mth.m_14116_((float)(x * x + z * z));
    }

    protected void m_5790_(EntityHitResult p_37259_) {
        super.m_5790_(p_37259_);
        if (this.canExplode(p_37259_.m_82443_())) {
            this.m_216990_(SoundEvents.f_11913_);
            this.f_19853_.m_7605_((Entity)this, (byte)99);
            List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), this::canExplode);
            list.forEach(t -> t.m_6469_(this.m_269291_().m_269036_((Entity)this, this.m_19749_()), 20.0f));
            this.m_146870_();
        }
    }

    public void m_7822_(byte p_19882_) {
        super.m_7822_(p_19882_);
        if (p_19882_ == 99) {
            this.f_19853_.m_7107_((ParticleOptions)UnleashedParticles.CELESTIAL_EXPLOSION.get(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_20069_() {
        return false;
    }

    protected void m_7380_(CompoundTag p_37265_) {
        super.m_7380_(p_37265_);
        p_37265_.m_128379_("isTrail", this.isTrail());
        p_37265_.m_128379_("isRewind", this.isRewind());
        if (((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            p_37265_.m_128362_("Owner", (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get());
        }
    }

    protected void m_7378_(CompoundTag p_37262_) {
        super.m_7378_(p_37262_);
        this.setTrail(p_37262_.m_128471_("isTrail"));
        this.setRewind(p_37262_.m_128471_("isRewind"));
        if (p_37262_.m_128403_("Owner")) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(p_37262_.m_128342_("Owner")));
        }
    }

    public void m_5602_(Entity owner) {
        if (owner == null) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(owner.m_20148_()));
        }
    }

    @Nullable
    public Entity m_19749_() {
        if (((Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            return UnleashedUtil.getEntityByUUID(this.f_19853_, (UUID)((Optional)this.f_19804_.m_135370_(OWNER_UUID)).get());
        }
        return null;
    }

    public void setRewind(boolean value) {
        this.f_19804_.m_135381_(IS_REWIND, (Object)value);
    }

    public boolean isRewind() {
        return (Boolean)this.f_19804_.m_135370_(IS_REWIND);
    }

    public void setTrail(boolean value) {
        this.f_19804_.m_135381_(IS_TRAIL, (Object)value);
    }

    public boolean isTrail() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRAIL);
    }

    public boolean hasTrail() {
        return this.trailPointer != -1 && this.isTrail();
    }

    public void tickTrail() {
        Vec3 currentPosition = this.m_20182_();
        if (this.trailPointer == -1) {
            for (int i = 0; i < this.trailPositions.length; ++i) {
                this.trailPositions[i] = currentPosition;
            }
        }
        if (++this.trailPointer == this.trailPositions.length) {
            this.trailPointer = 0;
        }
        this.trailPositions[this.trailPointer] = currentPosition;
    }

    @Override
    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.m_213877_()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x3F;
        int j = this.trailPointer - pointer - 1 & 0x3F;
        Vec3 d0 = this.trailPositions[j];
        Vec3 d1 = this.trailPositions[i].m_82546_(d0);
        return d0.m_82549_(d1.m_82490_((double)partialTick));
    }
}

