/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.entity.projectile;

import com.min01.unleashed.entity.AbstractOwnableEntity;
import com.min01.unleashed.entity.living.EntityCelestialJellyfish;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCelestialBeam
extends AbstractOwnableEntity<EntityCelestialJellyfish> {
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(EntityCelestialBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(EntityCelestialBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public Vec3 endPos = Vec3.f_82478_;
    public Vec3 collidePos = Vec3.f_82478_;

    public EntityCelestialBeam(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.f_19811_ = true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.calculateEndPos();
        List<LivingEntity> hit = this.raytraceEntities((Level)this.f_19853_, (Vec3)this.m_20182_(), (Vec3)this.endPos).entities;
        hit.forEach(t -> t.m_6469_(this.m_269291_().m_269104_((Entity)this, this.getOwner()), 6.0f));
        if (this.getOwner() == null || !((EntityCelestialJellyfish)this.getOwner()).m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19797_ >= 1000) {
            this.m_146870_();
        }
    }

    @Override
    public void m_7380_(CompoundTag p_37265_) {
        super.m_7380_(p_37265_);
        p_37265_.m_128350_("Yaw", this.getYaw());
        p_37265_.m_128350_("Pitch", this.getPitch());
    }

    @Override
    public void m_7378_(CompoundTag p_37262_) {
        super.m_7378_(p_37262_);
        this.setYaw(p_37262_.m_128457_("Yaw"));
        this.setPitch(p_37262_.m_128457_("Pitch"));
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    public void calculateEndPos() {
        double radius = 30.0;
        this.endPos = this.m_20182_().m_82520_(radius * Math.cos(this.getYaw()) * Math.cos(this.getPitch()), radius * Math.sin(this.getPitch()), radius * Math.sin(this.getYaw()) * Math.cos(this.getPitch()));
    }

    public BeamHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        BeamHitResult result = new BeamHitResult();
        this.collidePos = result.blockHit != null ? result.blockHit.m_82450_() : this.endPos;
        AABB aabb = new AABB(Math.min(this.m_20185_(), this.collidePos.f_82479_), Math.min(this.m_20186_(), this.collidePos.f_82480_), Math.min(this.m_20189_(), this.collidePos.f_82481_), Math.max(this.m_20185_(), this.collidePos.f_82479_), Math.max(this.m_20186_(), this.collidePos.f_82480_), Math.max(this.m_20189_(), this.collidePos.f_82481_));
        List entities = world.m_6443_(LivingEntity.class, aabb.m_82400_(1.0), t -> t != this.getOwner());
        for (LivingEntity entity : entities) {
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb2 = entity.m_20191_().m_82400_((double)pad);
            Optional hit = aabb2.m_82371_(from, to);
            if (aabb2.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public static class BeamHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

