/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.entity.ai.goal;

import com.min01.unleashed.config.UnleashedConfig;
import com.min01.unleashed.entity.UnleashedEntities;
import com.min01.unleashed.entity.ai.goal.AbstractCelestialJellyfishSkillGoal;
import com.min01.unleashed.entity.living.EntityCelestialJellyfish;
import com.min01.unleashed.entity.projectile.EntityCelestialOrb;
import com.min01.unleashed.sound.UnleashedSounds;
import com.min01.unleashed.util.UnleashedUtil;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CelestialJellyfishDashGoal
extends AbstractCelestialJellyfishSkillGoal {
    private int dashCount;
    private int dashTick;
    private boolean canContinueToUse = true;
    private boolean isDash;

    public CelestialJellyfishDashGoal(EntityCelestialJellyfish mob) {
        super(mob);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        ((EntityCelestialJellyfish)this.mob).setAnimationState(2);
        ((EntityCelestialJellyfish)this.mob).doTeleport();
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_() && ((EntityCelestialJellyfish)this.mob).m_217043_().m_188499_();
    }

    @Override
    public boolean m_8045_() {
        if (((EntityCelestialJellyfish)this.mob).m_5448_() == null || !((EntityCelestialJellyfish)this.mob).m_5448_().m_6084_() || !((EntityCelestialJellyfish)this.mob).m_6084_()) {
            this.nextSkillTickCount = 0;
            return false;
        }
        return super.m_8045_() && this.canContinueToUse;
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        --this.dashTick;
        if (this.dashCount == 5) {
            ((EntityCelestialJellyfish)this.mob).setFloat(true);
        }
        if (this.dashTick == 0) {
            ((EntityCelestialJellyfish)this.mob).doTeleport();
            ((EntityCelestialJellyfish)this.mob).setShowAfterImage(false);
            ((EntityCelestialJellyfish)this.mob).setLastLookPos(Vec3.f_82478_);
            this.isDash = false;
        }
        if (this.isDash) {
            List list = ((EntityCelestialJellyfish)this.mob).f_19853_.m_6443_(LivingEntity.class, ((EntityCelestialJellyfish)this.mob).m_20191_().m_82400_((double)1.85f), t -> !(t instanceof EntityCelestialJellyfish) && !t.m_7307_((Entity)this.mob));
            list.forEach(t -> ((EntityCelestialJellyfish)this.mob).m_7327_((Entity)t));
            if (((EntityCelestialJellyfish)this.mob).getAnimationTick() % 2 == 0) {
                Vec3 lookPos = UnleashedUtil.getLookPos(new Vec2(0.0f, ((EntityCelestialJellyfish)this.mob).m_6080_()), ((EntityCelestialJellyfish)this.mob).m_20182_(), 0.0, 0.0, -15.0);
                EntityCelestialOrb orb = new EntityCelestialOrb((EntityType<? extends ThrowableProjectile>)((EntityType)UnleashedEntities.CELESTIAL_ORB.get()), ((EntityCelestialJellyfish)this.mob).f_19853_);
                orb.m_146884_(lookPos);
                orb.m_5602_((Entity)this.mob);
                ((EntityCelestialJellyfish)this.mob).f_19853_.m_7967_((Entity)orb);
            }
        } else {
            ((EntityCelestialJellyfish)this.mob).m_20256_(Vec3.f_82478_);
            if (((EntityCelestialJellyfish)this.mob).isMove()) {
                if (((EntityCelestialJellyfish)this.mob).m_5448_() != null) {
                    ((EntityCelestialJellyfish)this.mob).m_7618_(EntityAnchorArgument.Anchor.EYES, ((EntityCelestialJellyfish)this.mob).m_5448_().m_146892_());
                }
                if (this.dashCount >= 5) {
                    if (((EntityCelestialJellyfish)this.mob).isClone()) {
                        ((EntityCelestialJellyfish)this.mob).m_146870_();
                    } else {
                        ((EntityCelestialJellyfish)this.mob).setHitTime(true);
                        ((EntityCelestialJellyfish)this.mob).setHitTime(((EntityCelestialJellyfish)this.mob).isSecondPhase() ? (Integer)UnleashedConfig.phaseTwoDealTime.get() : (Integer)UnleashedConfig.phaseOneDealTime.get());
                    }
                } else {
                    ((EntityCelestialJellyfish)this.mob).setShowWarning(true);
                }
                ((EntityCelestialJellyfish)this.mob).setMove(false);
            }
            if (((EntityCelestialJellyfish)this.mob).isEnd()) {
                ((EntityCelestialJellyfish)this.mob).setLastLookPos(UnleashedUtil.getLookPos(new Vec2(((EntityCelestialJellyfish)this.mob).m_146909_(), ((EntityCelestialJellyfish)this.mob).m_6080_()), ((EntityCelestialJellyfish)this.mob).m_20182_(), 0.0, 2.0, 100.0));
                this.skillWarmupDelay = ((EntityCelestialJellyfish)this.mob).isClone() || ((EntityCelestialJellyfish)this.mob).goal == ((Object)((Object)this)).getClass() ? this.m_183277_(12) : this.m_183277_(10);
                ((EntityCelestialJellyfish)this.mob).setEnd(false);
            }
        }
    }

    @Override
    protected void performSkill() {
        ((EntityCelestialJellyfish)this.mob).setShowWarning(false);
        if (this.dashCount < 5) {
            ((EntityCelestialJellyfish)this.mob).m_246865_(UnleashedUtil.fromToVector(((EntityCelestialJellyfish)this.mob).m_20182_(), ((EntityCelestialJellyfish)this.mob).getLastLookPos(), 6.0f));
            ((EntityCelestialJellyfish)this.mob).m_216990_((SoundEvent)UnleashedSounds.CELESTIAL_JELLYFISH_DASH.get());
            ((EntityCelestialJellyfish)this.mob).setShowAfterImage(true);
            this.isDash = true;
            ++this.dashCount;
            this.dashTick = 10;
        } else {
            this.canContinueToUse = false;
        }
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        ((EntityCelestialJellyfish)this.mob).setAnimationState(0);
        ((EntityCelestialJellyfish)this.mob).setAnimationTick(0);
        ((EntityCelestialJellyfish)this.mob).setLastLookPos(Vec3.f_82478_);
        ((EntityCelestialJellyfish)this.mob).setShowAfterImage(false);
        ((EntityCelestialJellyfish)this.mob).setShowWarning(false);
        ((EntityCelestialJellyfish)this.mob).setFloat(false);
        this.canContinueToUse = true;
        this.isDash = false;
        this.dashCount = 0;
        this.dashTick = 0;
    }

    @Override
    protected int getSkillUsingTime() {
        return 1000;
    }

    @Override
    protected int getSkillWarmupTime() {
        return 1000;
    }

    @Override
    protected int getSkillUsingInterval() {
        return 600;
    }
}

