/*
 * Decompiled with CFR 0.152.
 */
package com.min01.unleashed.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class UnleashedConfig {
    public static final UnleashedConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static ForgeConfigSpec.BooleanValue cameraShakes;
    public static ForgeConfigSpec.BooleanValue shaderEffects;
    public static ForgeConfigSpec.BooleanValue spawnJellyfish;
    public static ForgeConfigSpec.DoubleValue wormholeSpawnChance;
    public static ForgeConfigSpec.IntValue phaseOneDealTime;
    public static ForgeConfigSpec.IntValue phaseTwoDealTime;

    public UnleashedConfig(ForgeConfigSpec.Builder config) {
        config.push("Settings");
        cameraShakes = config.comment("disable/enable camera shakes in various place").define("cameraShakes", true);
        shaderEffects = config.comment("disable/enable fancy shader effects in various place").define("shaderEffects", true);
        spawnJellyfish = config.comment("disable/enable natural spawning of jellyfish in celestial field").define("spawnJellyfish", true);
        wormholeSpawnChance = config.comment("spawning chance of wormhole in end").defineInRange("wormholeSpawnChance", 1.0, 0.0, 100.0);
        phaseOneDealTime = config.comment("deal time after dash for phase 1 (in ticks)").defineInRange("phaseOneDealTime", 250, 0, Integer.MAX_VALUE);
        phaseTwoDealTime = config.comment("deal time after dash for phase 2 (in ticks)").defineInRange("phaseTwoDealTime", 150, 0, Integer.MAX_VALUE);
        config.pop();
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(UnleashedConfig::new);
        CONFIG = (UnleashedConfig)pair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)pair.getRight();
    }
}

