/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.helpers;

import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.objects.Vector3;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AOEMiningHelper {
    public static final Random random = new Random();

    public static void attemptBreakNeighbors(Level world, BlockPos pos, Player player, Set<Block> effectiveOn, Predicate<BlockState> predicate, boolean checkHarvestLevel) {
        BlockHitResult trace = AOEMiningHelper.calcRayTrace(world, player, ClipContext.Fluid.ANY);
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockTrace = trace;
            Direction face = blockTrace.m_82434_();
            int fortuneLevel = player.m_21205_().getEnchantmentLevel(Enchantments.f_44987_);
            int silkLevel = player.m_21205_().getEnchantmentLevel(Enchantments.f_44985_);
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.m_7918_(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.m_7918_(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.m_7918_(0, a, b);
                    }
                    AOEMiningHelper.attemptBreak(world, target, player, effectiveOn, predicate, fortuneLevel, silkLevel, checkHarvestLevel, null, (objPos, objState) -> {});
                }
            }
        }
    }

    public static void attemptBreak(Level world, BlockPos pos, Player player, Set<Block> effectiveOn, Predicate<BlockState> predicate, int fortuneLevel, int silkLevel, boolean checkHarvestLevel, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        boolean unbreakable;
        BlockState state = world.m_8055_(pos);
        BlockEntity iCertainlyHopeYouHaveATileEntityLicense = world.m_7702_(pos);
        boolean validHarvest = !checkHarvestLevel || player.m_21205_().m_41735_(state);
        boolean isEffective = effectiveOn.contains(state.m_60734_()) || predicate.test(state);
        boolean bl = unbreakable = state.m_204336_(BlockTags.f_13070_) || state.m_60734_() == Blocks.f_50085_ || state.m_60800_((BlockGetter)world, pos) < 0.0f;
        if (validHarvest && isEffective && !unbreakable) {
            world.m_46961_(pos, false);
            Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, (BlockEntity)iCertainlyHopeYouHaveATileEntityLicense, (Entity)player, (ItemStack)player.m_21205_());
            toolDamageConsumer.accept(pos, state);
            int exp = state.getExpDrop((LevelReader)world, world.f_46441_, pos, fortuneLevel, silkLevel);
            if (exp > 0 && world instanceof ServerLevel) {
                state.m_60734_().m_49805_((ServerLevel)world, pos, exp);
            }
        }
    }

    public static BlockHitResult calcRayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        return ItemBase.rayTrace(worldIn, player, fluidMode);
    }

    public static Vector3 calcRayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode, double distance) {
        float f7;
        float f5;
        double d0;
        float f4;
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vector3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f6 = f3 * (f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180))));
        Vec3 vector3d1 = vector3d.m_82520_((double)f6 * (d0 = distance), (double)(f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)))) * d0, (double)(f7 = f2 * f4) * d0);
        BlockHitResult result = worldIn.m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            return new Vector3(result.m_82450_());
        }
        Vector3 vec = new Vector3(player.m_20154_()).multiply(64.0).add(new Vector3(player.m_20182_()));
        return vec;
    }

    public static void harvestPlane(Level world, Player player, Direction dir, BlockPos pos, Predicate<BlockState> predicate, int radius, boolean harvestLevelCheck, @Nullable BlockPos excludedBlock, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
        int silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
        int supRad = (radius - 1) / 2;
        for (int a = -supRad; a <= supRad; ++a) {
            for (int b = -supRad; b <= supRad; ++b) {
                BlockPos target = null;
                if (dir == Direction.UP || dir == Direction.DOWN) {
                    target = pos.m_7918_(a, 0, b);
                }
                if (dir == Direction.NORTH || dir == Direction.SOUTH) {
                    target = pos.m_7918_(a, b, 0);
                }
                if (dir == Direction.EAST || dir == Direction.WEST) {
                    target = pos.m_7918_(0, a, b);
                }
                if (excludedBlock != null && target != null && target.equals((Object)excludedBlock)) continue;
                AOEMiningHelper.attemptBreak(world, target, player, Sets.newHashSet(), predicate, fortuneLevel, silkLevel, harvestLevelCheck, tool, toolDamageConsumer);
            }
        }
    }

    public static void harvestCube(Level world, Player player, Direction dir, BlockPos centralPos, Predicate<BlockState> predicate, int planeRadius, int depth, boolean harvestLevelCheck, @Nullable BlockPos excludedBlock, ItemStack tool, BiConsumer<BlockPos, BlockState> toolDamageConsumer) {
        for (int a = 0; a < depth; ++a) {
            int x = 0;
            int y = 0;
            int z = 0;
            if (dir == Direction.UP) {
                y -= a;
            }
            if (dir == Direction.DOWN) {
                y += a;
            }
            if (dir == Direction.SOUTH) {
                z -= a;
            }
            if (dir == Direction.NORTH) {
                z += a;
            }
            if (dir == Direction.EAST) {
                x -= a;
            }
            if (dir == Direction.WEST) {
                x += a;
            }
            AOEMiningHelper.harvestPlane(world, player, dir, new BlockPos((Vec3i)centralPos).m_7918_(x, y, z), predicate, planeRadius, harvestLevelCheck, excludedBlock, tool, toolDamageConsumer);
        }
    }
}

