/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.mixin;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public interface Trackable {
    public static final IdentityHashMap<Class<?>, ObjectOpenCustomHashSet<WeakReference<Trackable>>> TRACKABLE_MAP = new IdentityHashMap();
    public static final Hash.Strategy<WeakReference<Trackable>> WEAK_REFERENCE_STRATEGY = new Hash.Strategy<WeakReference<Trackable>>(){

        public int hashCode(WeakReference<Trackable> o) {
            return Objects.hashCode(o.get());
        }

        public boolean equals(WeakReference<Trackable> o, WeakReference<Trackable> k1) {
            return k1 != null && k1.get() == o.get();
        }
    };
    public static final ReentrantLock LOCK = new ReentrantLock();

    default public WeakReference<Trackable> wrap() {
        return new WeakReference<Trackable>(this);
    }

    default public void startTracking() {
        LOCK.lock();
        TRACKABLE_MAP.computeIfAbsent(this.atl$getBaseClass(), key -> Trackable.createWeakRefBasedSet()).add(this.wrap());
        LOCK.unlock();
    }

    public static ObjectOpenCustomHashSet<WeakReference<Trackable>> createWeakRefBasedSet() {
        return new ObjectOpenCustomHashSet<WeakReference<Trackable>>(WEAK_REFERENCE_STRATEGY){

            public boolean trim() {
                this.removeIf(reference -> reference.get() == null);
                return super.trim();
            }
        };
    }

    public static void clearNullReferences() {
        LOCK.lock();
        TRACKABLE_MAP.values().forEach(ObjectOpenCustomHashSet::trim);
        LOCK.unlock();
    }

    public static void startTracking(Object o) {
        if (o instanceof Trackable) {
            Trackable trackable = (Trackable)o;
            trackable.startTracking();
        }
    }

    public static Map<Class<?>, Map<Class<?>, Long>> getSummary() {
        HashMap resultMap = new HashMap();
        LOCK.lock();
        TRACKABLE_MAP.forEach((key, value) -> {
            Map<Class, Long> innerMap = value.stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.groupingBy(Object::getClass, Collectors.counting()));
            resultMap.put((Class<?>)key, (Map<Class<?>, Long>)innerMap);
        });
        LOCK.unlock();
        return resultMap;
    }

    public Class<?> atl$getBaseClass();
}

