/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.codec;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class CodecHelper {
    public static <T> Codec<T> jsonSerializerToCodec(final Function<T, JsonElement> serializer, final Function<JsonElement, T> deserializer) {
        return new Codec<T>(){

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                JsonElement json;
                try {
                    json = (JsonElement)serializer.apply(input);
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Failed to serialize object: " + e.getMessage());
                }
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, json));
            }

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                Object object;
                JsonElement json = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input);
                try {
                    object = deserializer.apply(json);
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Failed to deserialize object: " + e.getMessage());
                }
                return DataResult.success((Object)Pair.of(object, input));
            }
        };
    }

    public static <T> MapCodec<T> jsonSerializerToMapCodec(final Function<T, JsonObject> serializer, final Function<JsonObject, T> deserializer) {
        return new MapCodec<T>(){

            public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
                return Stream.empty();
            }

            public <T1> RecordBuilder<T1> encode(T input, DynamicOps<T1> ops, RecordBuilder<T1> prefix) {
                JsonObject json = (JsonObject)serializer.apply(input);
                for (String key : json.keySet()) {
                    prefix.add(key, JsonOps.INSTANCE.convertTo(ops, json.get(key)));
                }
                return prefix;
            }

            public <T1> DataResult<T> decode(DynamicOps<T1> ops, MapLike<T1> input) {
                Object object;
                JsonObject json = new JsonObject();
                input.entries().map(entry -> {
                    DataResult key = ops.getStringValue(entry.getFirst());
                    return key.result().isPresent() ? Pair.of((Object)((String)key.result().get()), (Object)entry.getSecond()) : null;
                }).filter(Objects::nonNull).forEach(entry -> json.add((String)entry.getFirst(), (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, entry.getSecond())));
                try {
                    object = deserializer.apply(json);
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Failed to deserialize object: " + e.getMessage());
                }
                return DataResult.success(object);
            }
        };
    }
}

