/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.mixin.BlockPropertiesAccessor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.util.TriPredicate;

public class BlockProperties {
    private Function<BlockState, MapColor> mapColor;
    private boolean hasCollision = true;
    private SoundType soundType = SoundType.f_56742_;
    private ToIntFunction<BlockState> lightLevel = state -> 0;
    private float explosionResistance;
    private float destroyTime;
    private boolean requiresCorrectTool = false;
    private boolean ticksRandomly = false;
    private float friction = 0.6f;
    private float speedFactor = 1.0f;
    private float jumpFactor = 1.0f;
    private boolean canOcclude = true;
    private boolean isAir = false;
    private boolean ignitedByLava = false;
    private PushReaction pushReaction = PushReaction.NORMAL;
    private NoteBlockInstrument instrument = NoteBlockInstrument.HARP;
    boolean replaceable = false;
    private TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor = BlockBehaviour.BlockStateBase::m_60838_;
    private TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating = (state, level, pos) -> state.m_280555_() && state.m_60838_(level, pos);
    private boolean hasDynamicShape = false;
    private boolean noLootTable = false;
    private Supplier<ResourceLocation> lootTableSupplier;

    public static BlockProperties create() {
        return new BlockProperties();
    }

    public static BlockProperties fromVanilla(BlockBehaviour.Properties vanilla) {
        BlockProperties properties = BlockProperties.create();
        properties.mapColor = vanilla.f_283880_;
        properties.hasCollision = vanilla.f_60884_;
        properties.soundType = vanilla.f_60885_;
        properties.lightLevel = vanilla.f_60886_;
        properties.explosionResistance = vanilla.f_60887_;
        properties.destroyTime = vanilla.f_60888_;
        properties.requiresCorrectTool = vanilla.f_60889_;
        properties.ticksRandomly = vanilla.f_60890_;
        properties.friction = vanilla.f_60891_;
        properties.speedFactor = vanilla.f_60892_;
        properties.jumpFactor = vanilla.f_60893_;
        properties.canOcclude = vanilla.f_60895_;
        properties.isAir = vanilla.f_60896_;
        properties.ignitedByLava = vanilla.f_278123_;
        properties.pushReaction = vanilla.f_278130_;
        properties.instrument = vanilla.f_279538_;
        properties.replaceable = vanilla.f_279630_;
        properties.isRedstoneConductor = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)vanilla.f_60898_).m_61035_(arg_0, arg_1, arg_2);
        properties.isSuffocating = (arg_0, arg_1, arg_2) -> ((BlockBehaviour.StatePredicate)vanilla.f_60899_).m_61035_(arg_0, arg_1, arg_2);
        properties.hasDynamicShape = vanilla.f_60903_;
        properties.lootTableSupplier = vanilla.f_60894_ != null ? () -> vanilla.f_60894_ : ((BlockPropertiesAccessor)vanilla).getLootTableSupplier();
        return properties;
    }

    public static BlockProperties copy(Block block) {
        return BlockProperties.fromVanilla(block.f_60439_);
    }

    public BlockProperties mapColor(Function<BlockState, MapColor> colorFunction) {
        this.mapColor = colorFunction;
        return this;
    }

    public BlockProperties mapColor(MapColor color) {
        return this.mapColor((BlockState state) -> color);
    }

    public BlockProperties collision(boolean hasCollision) {
        this.hasCollision = hasCollision;
        if (!hasCollision) {
            this.canOcclude = false;
        }
        return this;
    }

    public BlockProperties noCollision() {
        return this.collision(false);
    }

    public BlockProperties sound(SoundType soundTypeIn) {
        this.soundType = soundTypeIn;
        return this;
    }

    public BlockProperties lightLevel(ToIntFunction<BlockState> stateLightFunction) {
        this.lightLevel = stateLightFunction;
        return this;
    }

    public BlockProperties lightLevel(int light) {
        this.lightLevel = state -> light;
        return this;
    }

    public BlockProperties explosionResistance(float resistance) {
        this.explosionResistance = Math.max(0.0f, resistance);
        return this;
    }

    public BlockProperties destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockProperties strength(float strength) {
        return this.explosionResistance(strength).destroyTime(strength);
    }

    public BlockProperties requiresCorrectTool(boolean requiresCorrectTool) {
        this.requiresCorrectTool = requiresCorrectTool;
        return this;
    }

    public BlockProperties requiresCorrectTool() {
        return this.requiresCorrectTool(true);
    }

    public BlockProperties randomTicks(boolean receiveRandomTicks) {
        this.ticksRandomly = receiveRandomTicks;
        return this;
    }

    public BlockProperties randomTicks() {
        return this.randomTicks(true);
    }

    public BlockProperties friction(float friction) {
        this.friction = friction;
        return this;
    }

    public BlockProperties speedFactor(float factor) {
        this.speedFactor = factor;
        return this;
    }

    public BlockProperties jumpFactor(float factor) {
        this.jumpFactor = factor;
        return this;
    }

    public BlockProperties canOcclude(boolean canOcclude) {
        this.canOcclude = canOcclude;
        return this;
    }

    public BlockProperties noOcclusion() {
        return this.canOcclude(false);
    }

    public BlockProperties air(boolean isAir) {
        this.isAir = isAir;
        return this;
    }

    public BlockProperties air() {
        return this.air(true);
    }

    public BlockProperties ignitedByLava(boolean getsIgnitedByLava) {
        this.ignitedByLava = getsIgnitedByLava;
        return this;
    }

    public BlockProperties ignitedByLava() {
        return this.ignitedByLava(true);
    }

    public BlockProperties pushReaction(PushReaction pushReaction) {
        this.pushReaction = pushReaction;
        return this;
    }

    public BlockProperties instrument(NoteBlockInstrument instrument) {
        this.instrument = instrument;
        return this;
    }

    public BlockProperties replaceable(boolean isReplaceable) {
        this.replaceable = isReplaceable;
        return this;
    }

    public BlockProperties replaceable() {
        return this.replaceable(true);
    }

    public BlockProperties isRedstoneConductor(TriPredicate<BlockState, BlockGetter, BlockPos> isRedstoneConductor) {
        this.isRedstoneConductor = isRedstoneConductor;
        return this;
    }

    public BlockProperties isRedstoneConductor(boolean isRedstoneConductor) {
        this.isRedstoneConductor = (state, blockGetter, pos) -> isRedstoneConductor;
        return this;
    }

    public BlockProperties isSuffocating(TriPredicate<BlockState, BlockGetter, BlockPos> isSuffocating) {
        this.isSuffocating = isSuffocating;
        return this;
    }

    public BlockProperties isSuffocating(boolean isSuffocating) {
        this.isSuffocating = (state, blockGetter, pos) -> isSuffocating;
        return this;
    }

    public BlockProperties dynamicShape() {
        this.hasDynamicShape = true;
        return this;
    }

    public BlockProperties noLootTable() {
        this.noLootTable = true;
        this.lootTableSupplier = null;
        return this;
    }

    public BlockProperties lootTable(ResourceLocation lootTable) {
        this.noLootTable = false;
        this.lootTableSupplier = () -> lootTable;
        return this;
    }

    public BlockProperties lootTableFrom(Supplier<Block> block) {
        this.noLootTable = false;
        this.lootTableSupplier = block == null ? null : () -> ((Block)block.get()).m_60589_();
        return this;
    }

    @Deprecated
    public BlockBehaviour.Properties toUnderlying() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        if (this.mapColor != null) {
            properties.m_284495_(this.mapColor);
        }
        if (!this.hasCollision) {
            properties.m_60910_();
        }
        properties.m_60918_(this.soundType);
        properties.m_60953_(this.lightLevel);
        properties.m_60978_(this.explosionResistance);
        properties.m_155954_(this.destroyTime);
        if (this.requiresCorrectTool) {
            properties.m_60999_();
        }
        if (this.ticksRandomly) {
            properties.m_60977_();
        }
        properties.m_60911_(this.friction);
        properties.m_60956_(this.speedFactor);
        properties.m_60967_(this.jumpFactor);
        if (this.noLootTable) {
            properties.m_222994_();
        }
        ((BlockPropertiesAccessor)properties).setLootTableSupplier(this.lootTableSupplier);
        if (!this.canOcclude) {
            properties.m_60955_();
        }
        if (this.isAir) {
            properties.m_60996_();
        }
        if (this.ignitedByLava) {
            properties.m_278183_();
        }
        properties.m_278166_(this.pushReaction);
        properties.m_280658_(this.instrument);
        if (this.replaceable) {
            properties.m_280170_();
        }
        properties.m_60924_((arg_0, arg_1, arg_2) -> this.isRedstoneConductor.test(arg_0, arg_1, arg_2));
        properties.m_60960_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        properties.m_60971_((arg_0, arg_1, arg_2) -> this.isSuffocating.test(arg_0, arg_1, arg_2));
        if (this.hasDynamicShape) {
            properties.m_60988_();
        }
        return properties;
    }
}

