/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksgamerules.gamerules;

import de.markusbordihn.adaptiveperformancetweakscore.commands.CommandManager;
import de.markusbordihn.adaptiveperformancetweakscore.server.ServerLoadEvent;
import de.markusbordihn.adaptiveperformancetweaksgamerules.config.CommonConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class GameRuleManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Gamerules)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static GameRules gameRules;
    private static int timeBetweenUpdates;
    private static long lastUpdateTime;

    protected GameRuleManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        timeBetweenUpdates = (Integer)GameRuleManager.COMMON.timeBetweenUpdates.get() * 1000;
    }

    @SubscribeEvent
    public static void handleServerStartingEvent(ServerStartingEvent event) {
        gameRules = ServerLifecycleHooks.getCurrentServer().m_129900_();
        log.info("Gamerules will be optimized with an {} sec delay between updates.", (Object)(timeBetweenUpdates / 1000));
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.randomTickSpeedEnabled.get())) {
            log.info("Random Tick Speed will be optimized between {} and {}", (Object)1, GameRuleManager.COMMON.randomTickSpeed.get());
            if (gameRules.m_46215_(GameRules.f_46143_) != ((Integer)GameRuleManager.COMMON.randomTickSpeed.get()).intValue()) {
                GameRuleManager.setRandomTickSpeed((Integer)GameRuleManager.COMMON.randomTickSpeed.get());
            }
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.entityCrammingEnabled.get())) {
            log.info("Max Entity Cramming will be optimized between {} and {}", GameRuleManager.COMMON.minEntityCramming.get(), GameRuleManager.COMMON.maxEntityCramming.get());
            if (gameRules.m_46215_(GameRules.f_46149_) != ((Integer)GameRuleManager.COMMON.maxEntityCramming.get()).intValue()) {
                GameRuleManager.setMaxEntityCramming((Integer)GameRuleManager.COMMON.maxEntityCramming.get());
            }
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.blockExplodesEnabled.get())) {
            log.info("Block explosions will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.elytraMovementCheckEnabled.get())) {
            log.info("Elytra movement check will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.insomniaEnabled.get())) {
            log.info("Insomnia (phantoms spawn) will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.mobExplodesEnabled.get())) {
            log.info("Mob explosions will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.patrolSpawningEnabled.get())) {
            log.info("Patrol spawning will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.raidsEnabled.get())) {
            log.info("Raids will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.traderSpawningEnabled.get())) {
            log.info("Trader spawning will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.tntExplodesEnabled.get())) {
            log.info("TNT explosions will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.vinesSpreadEnabled.get())) {
            log.info("Vines spread will be automatically disabled during very high server load!");
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.wardenSpawningEnabled.get())) {
            log.info("Warden spawning will be automatically disabled during very high server load!");
        }
    }

    @SubscribeEvent
    public static void handleServerLoadEvent(ServerLoadEvent event) {
        gameRules = ServerLifecycleHooks.getCurrentServer().m_129900_();
        if (event.hasVeryHighServerLoad()) {
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.entityCrammingEnabled.get())) {
                GameRuleManager.decreaseMaxEntityCramming();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.randomTickSpeedEnabled.get())) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.blockExplodesEnabled.get())) {
                GameRuleManager.enableBlockExplosionDropDecay();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.elytraMovementCheckEnabled.get())) {
                GameRuleManager.disableElytraMovementCheck();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.insomniaEnabled.get())) {
                GameRuleManager.disableInsomnia();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.mobExplodesEnabled.get())) {
                GameRuleManager.enableMobExplosionDropDecay();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.raidsEnabled.get())) {
                GameRuleManager.disableRaids();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.patrolSpawningEnabled.get())) {
                GameRuleManager.disablePatrolSpawning();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.traderSpawningEnabled.get())) {
                GameRuleManager.disableTraderSpawning();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.tntExplodesEnabled.get())) {
                GameRuleManager.enableTntExplosionDropDecay();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.vinesSpreadEnabled.get())) {
                GameRuleManager.disableVinesSpread();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.wardenSpawningEnabled.get())) {
                GameRuleManager.disableWardenSpawning();
            }
            return;
        }
        if (event.hasHighServerLoad()) {
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.randomTickSpeedEnabled.get())) {
                GameRuleManager.decreaseRandomTickSpeed();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.raidsEnabled.get())) {
                GameRuleManager.disableRaids();
            }
            return;
        }
        if (System.currentTimeMillis() - lastUpdateTime < (long)timeBetweenUpdates) {
            return;
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.elytraMovementCheckEnabled.get())) {
            GameRuleManager.enableElytraMovementCheck();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.raidsEnabled.get())) {
            GameRuleManager.enableRaids();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.patrolSpawningEnabled.get())) {
            GameRuleManager.enablePatrolSpawning();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.insomniaEnabled.get())) {
            GameRuleManager.enableInsomnia();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.traderSpawningEnabled.get())) {
            GameRuleManager.enableTraderSpawning();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.tntExplodesEnabled.get())) {
            GameRuleManager.disableTntExplosionDropDecay();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.vinesSpreadEnabled.get())) {
            GameRuleManager.enableVinesSpread();
        }
        if (Boolean.TRUE.equals(GameRuleManager.COMMON.wardenSpawningEnabled.get())) {
            GameRuleManager.enableWardenSpawning();
        }
        if (event.hasNormalServerLoad()) {
            return;
        }
        if (event.hasLowServerLoad()) {
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.randomTickSpeedEnabled.get())) {
                GameRuleManager.increaseRandomTickSpeed();
            }
            if (Boolean.TRUE.equals(GameRuleManager.COMMON.entityCrammingEnabled.get())) {
                GameRuleManager.increaseMaxEntityCramming();
            }
        }
        lastUpdateTime = System.currentTimeMillis();
    }

    public static void enableBlockExplosionDropDecay() {
        if (!gameRules.m_46207_(GameRules.f_254629_)) {
            log.debug("Enable blockExplosionDropDecay");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_254629_, (boolean)true);
        }
    }

    public static void enableElytraMovementCheck() {
        if (gameRules.m_46207_(GameRules.f_46148_)) {
            log.debug("Enable ElytraMovementCheck");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46148_, (boolean)false);
        }
    }

    public static void disableElytraMovementCheck() {
        if (!gameRules.m_46207_(GameRules.f_46148_)) {
            log.debug("Disable ElytraMovementCheck");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46148_, (boolean)true);
        }
    }

    public static void enableInsomnia() {
        if (!gameRules.m_46207_(GameRules.f_46155_)) {
            log.debug("Enable Insomnia");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46155_, (boolean)true);
        }
    }

    public static void disableInsomnia() {
        if (gameRules.m_46207_(GameRules.f_46155_)) {
            log.debug("Disable Insomnia");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46155_, (boolean)false);
        }
    }

    public static void enableMobExplosionDropDecay() {
        if (!gameRules.m_46207_(GameRules.f_254692_)) {
            log.debug("Enable mobExplosionDropDecay");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_254692_, (boolean)true);
        }
    }

    public static void enablePatrolSpawning() {
        if (!gameRules.m_46207_(GameRules.f_46124_)) {
            log.debug("Enable PatrolSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46124_, (boolean)true);
        }
    }

    public static void disablePatrolSpawning() {
        if (gameRules.m_46207_(GameRules.f_46124_)) {
            log.debug("Disable PatrolSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46124_, (boolean)false);
        }
    }

    public static void enableRaids() {
        if (gameRules.m_46207_(GameRules.f_46154_)) {
            log.debug("Enable Raids");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46154_, (boolean)false);
        }
    }

    public static void disableRaids() {
        if (!gameRules.m_46207_(GameRules.f_46154_)) {
            log.debug("Disable Raids");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46154_, (boolean)true);
        }
    }

    public static void enableTraderSpawning() {
        if (!gameRules.m_46207_(GameRules.f_46125_)) {
            log.debug("Enable TraderSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46125_, (boolean)true);
        }
    }

    public static void disableTraderSpawning() {
        if (gameRules.m_46207_(GameRules.f_46125_)) {
            log.debug("Disable TraderSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46125_, (boolean)false);
        }
    }

    public static void enableTntExplosionDropDecay() {
        if (!gameRules.m_46207_(GameRules.f_254705_)) {
            log.debug("Enable tntExplosionDropDecay");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_254705_, (boolean)true);
        }
    }

    public static void disableTntExplosionDropDecay() {
        if (gameRules.m_46207_(GameRules.f_254705_)) {
            log.debug("Disable tntExplosionDropDecay");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_254705_, (boolean)false);
        }
    }

    public static void enableVinesSpread() {
        if (!gameRules.m_46207_(GameRules.f_268705_)) {
            log.debug("Enable VinesSpread");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_268705_, (boolean)true);
        }
    }

    public static void disableVinesSpread() {
        if (gameRules.m_46207_(GameRules.f_268705_)) {
            log.debug("Disable VinesSpread");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_268705_, (boolean)false);
        }
    }

    public static void enableWardenSpawning() {
        if (!gameRules.m_46207_(GameRules.f_220347_)) {
            log.debug("Enable WardenSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_220347_, (boolean)true);
        }
    }

    public static void disableWardenSpawning() {
        if (gameRules.m_46207_(GameRules.f_220347_)) {
            log.debug("Disable WardenSpawning");
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_220347_, (boolean)false);
        }
    }

    public static void decreaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.m_46215_(GameRules.f_46143_) - 1);
    }

    public static void increaseRandomTickSpeed() {
        GameRuleManager.setRandomTickSpeed(gameRules.m_46215_(GameRules.f_46143_) + 1);
    }

    public static void setRandomTickSpeed(int tickSpeed) {
        int currentTickSpeed = gameRules.m_46215_(GameRules.f_46143_);
        if (tickSpeed < 1) {
            tickSpeed = 1;
        } else if (tickSpeed > (Integer)GameRuleManager.COMMON.randomTickSpeed.get()) {
            tickSpeed = (Integer)GameRuleManager.COMMON.randomTickSpeed.get();
        }
        if (currentTickSpeed != tickSpeed) {
            log.debug("Changing randomTickSpeed from {} to {}", (Object)currentTickSpeed, (Object)tickSpeed);
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46143_, (int)tickSpeed);
        }
    }

    public static void decreaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.m_46215_(GameRules.f_46149_) - 1);
    }

    public static void increaseMaxEntityCramming() {
        GameRuleManager.setMaxEntityCramming(gameRules.m_46215_(GameRules.f_46149_) + 1);
    }

    public static void setMaxEntityCramming(int maxEntity) {
        int currentMaxEntityCramming;
        if (maxEntity < (Integer)GameRuleManager.COMMON.minEntityCramming.get()) {
            maxEntity = (Integer)GameRuleManager.COMMON.minEntityCramming.get();
        } else if (maxEntity > (Integer)GameRuleManager.COMMON.maxEntityCramming.get()) {
            maxEntity = (Integer)GameRuleManager.COMMON.maxEntityCramming.get();
        }
        if (ModList.get().isLoaded("minecolonies") && maxEntity < (Integer)GameRuleManager.COMMON.minEntityCrammingMineColonies.get()) {
            log.warn("WARNING: The recommended value for minEntityCramming with {} is min. {} instead of {}!", (Object)"MineColonies", GameRuleManager.COMMON.minEntityCrammingMineColonies.get(), GameRuleManager.COMMON.minEntityCramming.get());
            log.info("The minEntityCramming will be automatically set to {}!", GameRuleManager.COMMON.minEntityCrammingMineColonies.get());
            maxEntity = (Integer)GameRuleManager.COMMON.minEntityCrammingMineColonies.get();
        }
        if ((currentMaxEntityCramming = gameRules.m_46215_(GameRules.f_46149_)) != maxEntity) {
            log.debug("Changing maxEntityCramming from {} to {}", (Object)currentMaxEntityCramming, (Object)maxEntity);
            CommandManager.executeGameRuleCommand((GameRules.Key)GameRules.f_46149_, (int)maxEntity);
        }
    }

    public static Map<String, String> getGameRulesOverview() {
        ConcurrentHashMap<String, String> overview = new ConcurrentHashMap<String, String>();
        overview.put(GameRules.f_46149_.m_46328_(), String.valueOf(gameRules.m_46215_(GameRules.f_46149_)));
        overview.put(GameRules.f_46143_.m_46328_(), String.valueOf(gameRules.m_46215_(GameRules.f_46143_)));
        overview.put(GameRules.f_254629_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_254629_)));
        overview.put(GameRules.f_46148_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_46148_)));
        overview.put(GameRules.f_46155_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_46155_)));
        overview.put(GameRules.f_254692_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_254692_)));
        overview.put(GameRules.f_46124_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_46124_)));
        overview.put(GameRules.f_46154_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_46154_)));
        overview.put(GameRules.f_254705_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_254705_)));
        overview.put(GameRules.f_46125_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_46125_)));
        overview.put(GameRules.f_268705_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_268705_)));
        overview.put(GameRules.f_220347_.m_46328_(), String.valueOf(gameRules.m_46207_(GameRules.f_220347_)));
        return overview;
    }

    static {
        timeBetweenUpdates = 10000;
        lastUpdateTime = System.currentTimeMillis();
    }
}

