/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksgamerules.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.markusbordihn.adaptiveperformancetweakscore.commands.CustomCommand;
import de.markusbordihn.adaptiveperformancetweaksgamerules.gamerules.GameRuleManager;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class GameRuleCommand
extends CustomCommand {
    private static final GameRuleCommand command = new GameRuleCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"gamerules").requires(cs -> cs.m_6761_(2))).executes((Command)command);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        TreeMap<String, String> gameRules = new TreeMap<String, String>(GameRuleManager.getGameRulesOverview());
        if (gameRules.isEmpty()) {
            GameRuleCommand.sendFeedback(context, (String)"Unable to get game rules overview!");
        } else {
            GameRuleCommand.sendFeedback(context, (String)"Game Rule Overview\n===================");
            StringBuilder output = new StringBuilder();
            for (Map.Entry gamerule : gameRules.entrySet()) {
                output.append(String.format("%s: %s\n", gamerule.getKey(), gamerule.getValue()));
            }
            GameRuleCommand.sendFeedback(context, (String)output.toString());
        }
        return 0;
    }
}

