/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.network;

import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.common.network.Packet;
import io.github.flemmli97.tenshilib.common.utils.AOEWeaponHandler;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;

public class C2SPacketHit
implements Packet {
    public static final ResourceLocation ID = new ResourceLocation("tenshilib", "c2s_item_special");
    private final HitType type;

    public C2SPacketHit(HitType type) {
        this.type = type;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    public static C2SPacketHit fromBytes(FriendlyByteBuf buf) {
        return new C2SPacketHit(HitType.values()[buf.readInt()]);
    }

    public static void handlePacket(C2SPacketHit pkt, ServerPlayer player) {
        IAOEWeapon weapon;
        EntityHitResult res;
        IExtendedWeapon item;
        Item item2;
        ItemStack stack = player.m_21205_();
        if (pkt.type == HitType.EXT && (item2 = stack.m_41720_()) instanceof IExtendedWeapon && (item = (IExtendedWeapon)item2).onServerSwing((LivingEntity)player, stack) && (res = RayTraceUtils.calculateEntityFromLook((LivingEntity)player, item.getRange((LivingEntity)player, stack))) != null && res.m_82443_() != null && item.onHit((LivingEntity)player, stack, res.m_82443_())) {
            player.m_5706_(res.m_82443_());
        }
        if (pkt.type == HitType.AOE && (item2 = stack.m_41720_()) instanceof IAOEWeapon && (weapon = (IAOEWeapon)item2).onServerSwing((LivingEntity)player, stack)) {
            AOEWeaponHandler.onAOEWeaponSwing((Player)player, stack, weapon);
        }
    }

    public static enum HitType {
        EXT,
        AOE;

    }
}

