/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.common.entity;

import io.github.flemmli97.tenshilib.TenshiLib;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, Level world, UUID uuid) {
        return (T)EntityUtil.findFromUUID(clss, world, uuid, t -> true);
    }

    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, Level world, UUID uuid, Predicate<T> pred) {
        if (world instanceof ServerLevel) {
            Entity e = ((ServerLevel)world).m_8791_(uuid);
            if (e != null && clss.isAssignableFrom(e.getClass()) && pred.test(e)) {
                return (T)e;
            }
        } else {
            for (Entity e : ((ClientLevel)world).m_104735_()) {
                if (!e.m_20148_().equals(uuid) || !clss.isAssignableFrom(e.getClass()) || !pred.test(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public static ItemStack findItem(Player player, Predicate<ItemStack> pred, boolean searchArmor, boolean offHand) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!pred.test(stack)) continue;
            return stack;
        }
        if (searchArmor) {
            for (ItemStack stack : player.m_150109_().f_35975_) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        if (offHand) {
            for (ItemStack stack : player.m_150109_().f_35976_) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean isSameMultipart(Entity entity, Entity parent) {
        if (parent == null) {
            return false;
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)entity;
            if (entity.m_6095_().m_204039_(TenshiLib.MULTIPART_ENTITY)) {
                return parent.m_20148_().equals(ownable.m_21805_());
            }
        }
        if (entity instanceof EnderDragonPart) {
            EnderDragonPart part = (EnderDragonPart)entity;
            return part.f_31010_ == parent;
        }
        return false;
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Entity target) {
        AABB aabb = target.m_20191_();
        return EntityUtil.getStraightProjectileTarget(from, target.m_20182_(), aabb.f_82289_ + (double)target.m_20206_() * 0.15, aabb.f_82292_ - (double)target.m_20206_() * 0.15);
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Vec3 target, double minY, double maxY) {
        return new Vec3(target.m_7096_(), Mth.m_14008_((double)from.m_7098_(), (double)minY, (double)maxY), target.m_7094_());
    }
}

