/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class LongData
extends AbstractData<Long>
implements IContainerData {
    private long _lastValue;

    public static LongData immutable(ModContainer container, boolean isClientSide, long value) {
        return LongData.of(container, isClientSide, (NonNullSupplier<Supplier<Long>>)((NonNullSupplier)() -> () -> value));
    }

    public static LongData sampled(int frequency, ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Long>> serverSideGetter) {
        return LongData.of(container, isClientSide, (NonNullSupplier<Supplier<Long>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static LongData of(ModContainer container, boolean isClientSide, NonNullSupplier<Supplier<Long>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        LongData data = isClientSide ? new LongData() : new LongData(serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static LongData of(ModContainer container, boolean isClientSide, long[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        LongData data = LongData.of(container, isClientSide, (NonNullSupplier<Supplier<Long>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        long current = (Long)this._getter.get();
        if (this._lastValue != current) {
            this._lastValue = current;
            return buffer -> buffer.m_130103_(current);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.m_130258_());
    }

    @Override
    @Nullable
    public Long defaultValue() {
        return 0L;
    }

    private LongData() {
    }

    private LongData(NonNullSupplier<Supplier<Long>> serverSideGetter) {
        super(serverSideGetter);
        this._lastValue = 0L;
    }
}

