/*
 * Decompiled with CFR 0.152.
 */
package net.thetct.tctcore.network;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.thetct.tctcore.TctcoreMod;
import net.thetct.tctcore.procedures.DiscordHelpProcedure;
import net.thetct.tctcore.procedures.OpenInstallProcedure;
import net.thetct.tctcore.procedures.OpenSettingsProcedure;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public record TCTcoreButtonMessage(int buttonID, int x, int y, int z) {
    public TCTcoreButtonMessage(FriendlyByteBuf buffer) {
        this(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt());
    }

    public static void buffer(TCTcoreButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TCTcoreButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TCTcoreButtonMessage.handleButtonAction((Player)context.getSender(), message.buttonID, message.x, message.y, message.z));
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            OpenSettingsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 1) {
            OpenInstallProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            DiscordHelpProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TctcoreMod.addNetworkMessage(TCTcoreButtonMessage.class, TCTcoreButtonMessage::buffer, TCTcoreButtonMessage::new, TCTcoreButtonMessage::handler);
    }
}

