/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stal111.forbidden_arcanus.client.model.MagicCircleModel;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HephaestusForgeRenderer
implements BlockEntityRenderer<HephaestusForgeBlockEntity> {
    private final MagicCircleModel magicCircleModel;

    public HephaestusForgeRenderer(BlockEntityRendererProvider.Context context) {
        this.magicCircleModel = new MagicCircleModel(context);
    }

    public void render(@Nonnull HephaestusForgeBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack stack;
        if (blockEntity.hasMagicCircle()) {
            blockEntity.getMagicCircle().render(poseStack, partialTicks, bufferSource, packedLight, this.magicCircleModel);
        }
        if (blockEntity.hasValidRitualIndicator()) {
            blockEntity.getValidRitualIndicator().render(poseStack, partialTicks, bufferSource, packedLight, this.magicCircleModel.validRitualIndicator());
        }
        if (!(stack = blockEntity.getStack(4)).m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 1.3, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252961_(((float)blockEntity.getDisplayCounter() + partialTicks) / 20.0f));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(@Nonnull HephaestusForgeBlockEntity blockEntity) {
        return blockEntity.useExpandedRenderBoundingBox();
    }
}

