/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class FeyAltarRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final List<Ingredient> inputs;
    private final NonNullList<Ingredient> inputList;

    public FeyAltarRecipe(ResourceLocation id, ItemStack output, List<Ingredient> inputs) {
        this.id = id;
        this.output = output;
        this.inputs = ImmutableList.copyOf(inputs);
        this.inputList = NonNullList.m_122780_((int)this.inputs.size(), (Object)Ingredient.f_43901_);
        for (int i = 0; i < this.inputs.size(); ++i) {
            this.inputList.set(i, (Object)this.inputs.get(i));
        }
    }

    public boolean matches(@NotNull SimpleContainer inventory, Level level) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_() - 1; ++i) {
            stacks.add(i, inventory.m_8020_(i));
        }
        return FeyAltarRecipe.matchesLists(this.inputs, stacks);
    }

    @NotNull
    public ItemStack assemble(@NotNull SimpleContainer simpleContainer, @NotNull RegistryAccess registries) {
        return this.m_8043_(registries);
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess registries) {
        return this.output.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputList;
    }

    public static boolean matchesLists(List<Ingredient> ingredients, List<ItemStack> stacks) {
        if (ingredients.size() != stacks.size()) {
            return false;
        }
        ArrayList<ItemStack> left = new ArrayList<ItemStack>(stacks);
        block0: for (Ingredient ingredient : ingredients) {
            Iterator itr = left.iterator();
            while (itr.hasNext()) {
                if (!ingredient.test((ItemStack)itr.next())) continue;
                itr.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<FeyAltarRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("feywild", "fey_altar");

        @Nonnull
        public FeyAltarRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (JsonElement jsonElement : ingredients) {
                inputs.add((Object)Ingredient.m_43917_((JsonElement)jsonElement));
            }
            ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            return new FeyAltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        @Nullable
        public FeyAltarRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            int inputSize = buffer.m_130242_();
            ImmutableList.Builder inputs = ImmutableList.builder();
            for (int i = 0; i < inputSize; ++i) {
                inputs.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            return new FeyAltarRecipe(recipeId, output, (List<Ingredient>)inputs.build());
        }

        public void toNetwork(FriendlyByteBuf buffer, FeyAltarRecipe recipe) {
            buffer.m_130130_(recipe.m_7527_().size());
            recipe.inputs.forEach(i -> i.m_43923_(buffer));
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static class Type
    implements RecipeType<FeyAltarRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fey_altar";
    }
}

