/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.patchouli.component;

import java.util.List;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class CircularIngredientsComponent
implements ICustomComponent {
    public IVariable items;
    private transient int x;
    private transient int y;
    private transient List<Ingredient> ingredients;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        IVariable ingredients = (IVariable)lookup.apply(this.items);
        this.ingredients = ingredients.unwrap().isJsonNull() ? List.of() : ingredients.asStream().map(var -> (Ingredient)var.as(Ingredient.class)).toList();
    }

    public void render(@Nonnull GuiGraphics graphics, @Nonnull IComponentRenderContext context, float partialTick, int mouseX, int mouseY) {
        if (this.ingredients == null) {
            return;
        }
        float degreePerInput = 360.0f / (float)this.ingredients.size();
        float angle = 0.0f;
        for (Ingredient ingredient : this.ingredients) {
            this.renderIngredientAtAngle(graphics, context, angle, ingredient, mouseX, mouseY);
            angle += degreePerInput;
        }
    }

    private void renderIngredientAtAngle(GuiGraphics graphics, IComponentRenderContext context, float angle, Ingredient ingredient, int mouseX, int mouseY) {
        if (!ingredient.m_43947_()) {
            int radius = 32;
            double xPos = (double)this.x + Math.cos((double)(angle -= 90.0f) * Math.PI / 180.0) * (double)radius + (double)radius;
            double yPos = (double)this.y + Math.sin((double)angle * Math.PI / 180.0) * (double)radius + (double)radius;
            context.renderIngredient(graphics, (int)xPos, (int)yPos, mouseX, mouseY, ingredient);
        }
    }
}

