/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.config.ModConfig;
import com.saphienyako.feywild.entity.base.FeyBase;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record ToggleAbilityMessage(int entityId, boolean abilityActive) {
    public static void encode(ToggleAbilityMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId());
        buffer.writeBoolean(msg.abilityActive());
    }

    public static ToggleAbilityMessage decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        boolean abilityActive = buffer.readBoolean();
        return new ToggleAbilityMessage(id, abilityActive);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        FeyBase entity;
        Level level = supplier.get().getSender().m_9236_();
        if (this.entityId() != -1 && (entity = (FeyBase)level.m_6815_(this.entityId)) != null) {
            entity.setAbilityActive(this.abilityActive);
            if (!this.abilityActive) {
                Objects.requireNonNull(supplier.get().getSender()).m_213846_(entity.getFeyAbilityOffMessage());
                if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue() && entity.getVoiceActive().booleanValue()) {
                    level.m_5594_(null, entity.m_20183_(), entity.getAbilityOffSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else {
                Objects.requireNonNull(supplier.get().getSender()).m_213846_(entity.getFeyAbilityOnMessage());
                if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue() && entity.getVoiceActive().booleanValue()) {
                    level.m_5594_(null, entity.m_20183_(), entity.getAbilityOnSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            }
        }
    }
}

