/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record ParticleMessage(Type type, BlockPos pos) {
    public static void encode(ParticleMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)msg.type());
        buffer.m_130064_(msg.pos);
    }

    public static ParticleMessage decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        BlockPos pos = buffer.m_130135_();
        return new ParticleMessage(type, pos);
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        ParticleMessage.withLevelDo(level -> {
            RandomSource ran = level.f_46441_;
            switch (this.type) {
                case DANDELION_FLUFF: {
                    for (int i = 0; i < 40; ++i) {
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos().m_123343_(), 0.6 * (ran.m_188500_() - 0.5), 0.6 * (ran.m_188500_() - 0.3), 0.6 * (ran.m_188500_() - 0.5));
                    }
                    break;
                }
                case FEY_HEART: {
                    int y = this.pos.m_123342_() + 1;
                    for (int i = 0; i < 5; ++i) {
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123750_, true, (double)this.pos.m_123341_() - 0.3 + 0.6 * ran.m_188500_(), (double)y + 1.9 * ran.m_188500_(), (double)this.pos.m_123343_() - 0.3 + 0.6 * ran.m_188500_(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case CROPS_GROW: {
                    for (int i = 0; i < 10; ++i) {
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, (double)this.pos.m_123341_() - 0.3 + 0.6 * level.f_46441_.m_188500_(), (double)this.pos.m_123342_() + 0.8 * level.f_46441_.m_188500_(), (double)this.pos.m_123343_() - 0.3 + 0.6 * level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case MOB_COLLECT: {
                    for (int i = 0; i < 20; ++i) {
                        level.m_6493_((ParticleOptions)ParticleTypes.f_123745_, true, (double)this.pos.m_123341_() - 0.3 + 0.9 * level.f_46441_.m_188500_(), (double)this.pos.m_123342_() + 1.2 * level.f_46441_.m_188500_(), (double)this.pos.m_123343_() - 0.3 + 0.9 * level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case CROPS_RESET: {
                    for (int i = 0; i < 10; ++i) {
                        level.m_6493_((ParticleOptions)ParticleTypes.f_175827_, true, (double)this.pos.m_123341_() - 0.3 + 0.6 * level.f_46441_.m_188500_(), (double)this.pos.m_123342_() + 0.8 * level.f_46441_.m_188500_(), (double)this.pos.m_123343_() - 0.3 + 0.6 * level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        });
    }

    public static enum Type {
        DANDELION_FLUFF,
        FEY_HEART,
        CROPS_GROW,
        CROPS_RESET,
        MOB_COLLECT;

    }
}

