/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.config.ModConfig;
import com.saphienyako.feywild.entity.base.FeyBase;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.ParticleMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record DismissEntityMessage(int entityId) {
    public static void encode(DismissEntityMessage msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.entityId());
    }

    public static DismissEntityMessage decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        return new DismissEntityMessage(id);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        FeyBase entity;
        Level level = supplier.get().getSender().m_9236_();
        if (this.entityId() != -1 && (entity = (FeyBase)level.m_6815_(this.entityId)) != null) {
            entity.m_19998_(entity.getDismissItem());
            Objects.requireNonNull(supplier.get().getSender()).m_213846_(entity.getFeyDismissMessage());
            if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue() && entity.getVoiceActive().booleanValue()) {
                level.m_5594_(null, entity.m_20183_(), entity.getDismissSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            FeywildNetwork.sendParticles(level, ParticleMessage.Type.DANDELION_FLUFF, entity.m_20183_().m_7494_());
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }
}

