/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.network;

import com.saphienyako.feywild.particle.ModParticles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record AltarParticleMessage(Type type, BlockPos pos, int progress, int maxProgress) {
    public static void encode(AltarParticleMessage msg, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)msg.type());
        buffer.m_130064_(msg.pos);
        buffer.writeInt(msg.progress);
        buffer.writeInt(msg.maxProgress);
    }

    public static AltarParticleMessage decode(FriendlyByteBuf buffer) {
        Type type = (Type)buffer.m_130066_(Type.class);
        BlockPos pos = buffer.m_130135_();
        int progress = buffer.readInt();
        int maxProgress = buffer.readInt();
        return new AltarParticleMessage(type, pos, progress, maxProgress);
    }

    private static void withLevelDo(Consumer<Level> action) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            action.accept((Level)level);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        AltarParticleMessage.withLevelDo(l -> {
            switch (this.type) {
                case ALTAR_01: {
                    for (int i = 0; i < 20; ++i) {
                        l.m_6493_((ParticleOptions)ModParticles.FEY_SPARKLE_PARTICLE.get(), true, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.2, (double)this.pos.m_123343_() + 0.5, 0.5 - l.f_46441_.m_188500_(), 0.7 - l.f_46441_.m_188500_(), 0.5 - l.f_46441_.m_188500_());
                        l.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 1.2, (double)this.pos.m_123343_() + 0.5, 0.5 - l.f_46441_.m_188500_(), 0.7 - l.f_46441_.m_188500_(), 0.5 - l.f_46441_.m_188500_());
                    }
                    break;
                }
                case ALTAR_02: {
                    double progressScaled = (double)this.progress / (double)this.maxProgress;
                    double anglePerStack = 1.2566370614359172;
                    for (int idx = 0; idx < 5; ++idx) {
                        double shiftX = Math.cos((double)l.m_46467_() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        double shiftZ = Math.sin((double)l.m_46467_() / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                        l.m_6493_((ParticleOptions)ModParticles.FEY_SPARKLE_PARTICLE.get(), true, (double)this.pos.m_123341_() + 0.5 + shiftX, (double)(this.pos.m_123342_() + 1) + progressScaled, (double)this.pos.m_123343_() + 0.5 + shiftZ, 0.0, 0.0, 0.0);
                        l.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.pos.m_123341_() + 0.5 + shiftX, (double)(this.pos.m_123342_() + 1) + progressScaled, (double)this.pos.m_123343_() + 0.5 + shiftZ, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case ALTAR_03: {
                    if ((double)l.f_46441_.m_188501_() < 0.1) {
                        l.m_6493_((ParticleOptions)ModParticles.FEY_SPARKLE_PARTICLE.get(), true, (double)this.pos.m_123341_() + Math.random(), (double)(this.pos.m_123342_() + 1) + Math.random(), (double)this.pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                    }
                    if (!((double)l.f_46441_.m_188501_() < 0.02)) break;
                    l.m_6493_((ParticleOptions)ParticleTypes.f_123810_, true, (double)this.pos.m_123341_() + Math.random(), (double)(this.pos.m_123342_() + 1) + Math.random(), (double)this.pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
                }
            }
        });
    }

    public static enum Type {
        ALTAR_01,
        ALTAR_02,
        ALTAR_03;

    }
}

