/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.item;

import com.saphienyako.feywild.block.GiantFlowerBlock;
import com.saphienyako.feywild.block.ModBlocks;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class GiantFlowerSeedItem
extends Item {
    private final GiantFlowerBlock block;

    public GiantFlowerSeedItem(GiantFlowerBlock block) {
        super(new Item.Properties());
        this.block = block;
    }

    public static void placeFlower(GiantFlowerBlock block, LevelAccessor level, BlockPos pos, RandomSource random, int placeFlags) {
        for (int i = 0; i < block.height; ++i) {
            BlockState baseState = i == block.height - 1 ? block.flowerState(level, pos.m_6630_(i), random) : block.m_49966_();
            level.m_7731_(pos.m_6630_(i), (BlockState)baseState.m_61124_((Property)GiantFlowerBlock.PART, (Comparable)Integer.valueOf(i + (4 - block.height))), placeFlags);
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPlaceContext blockContext = new BlockPlaceContext(context);
        BlockPos pos = context.m_8083_();
        if (!level.m_8055_(pos).m_60629_(blockContext)) {
            pos = pos.m_7494_();
        }
        if (!Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(BlockTags.f_144274_).contains((Object)level.m_8055_(pos.m_7495_()).m_60734_())) {
            return InteractionResult.PASS;
        }
        for (int i = 0; i < this.block.height; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_60629_(blockContext)) continue;
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            GiantFlowerSeedItem.placeFlower(this.block, (LevelAccessor)level, pos, level.f_46441_, 3);
            if (context.m_43723_() != null && !context.m_43723_().m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (level != null) {
            if (this.block == ModBlocks.GIANT_SUN_FLOWER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"message.feywild.giant_sun_flower").m_130940_(ChatFormatting.BLUE));
            }
            if (this.block == ModBlocks.GIANT_CROCUS_FLOWER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"message.feywild.giant_crocus_flower").m_130940_(ChatFormatting.BLUE));
            }
            if (this.block == ModBlocks.GIANT_DANDELION_FLOWER.get()) {
                tooltip.add((Component)Component.m_237115_((String)"message.feywild.giant_sun_flower").m_130940_(ChatFormatting.BLUE));
            }
        }
        super.m_7373_(stack, level, tooltip, flag);
    }
}

