/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.base.PixieBase;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.ParticleMessage;
import com.saphienyako.feywild.sound.ModSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GatherCropsAbilityGoal
extends Goal {
    protected final Level level;
    protected final PixieBase entity;
    protected ItemStack item;
    protected boolean foundViableCrop;
    private int ticksLeft = 0;

    public GatherCropsAbilityGoal(PixieBase entity, Level level) {
        this.level = level;
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.reset();
            } else if (this.ticksLeft == 5) {
                if (this.foundViableCrop && this.item != null) {
                    if (this.item.m_41720_() == Items.f_42404_) {
                        this.entity.m_19998_((ItemLike)Objects.requireNonNull(Items.f_42405_));
                    } else if (this.item.m_41720_() == Items.f_42733_) {
                        this.entity.m_19998_((ItemLike)Objects.requireNonNull(Items.f_42732_));
                    } else {
                        this.entity.m_19983_(Objects.requireNonNull(this.item));
                    }
                    this.entity.m_5496_(SoundEvents.f_11763_, 0.7f, 1.0f);
                }
            } else if (this.ticksLeft == 20) {
                this.locateCrops(this.entity.m_20183_());
                if (this.foundViableCrop && this.item != null) {
                    this.spellCasting();
                }
            }
        }
    }

    private void locateCrops(BlockPos pos) {
        for (int xd = -8; xd <= 8; ++xd) {
            for (int zd = -8; zd <= 8; ++zd) {
                for (int yd = 8; yd >= -8; --yd) {
                    CropBlock cropBlock;
                    BlockPos target = pos.m_7918_(xd, yd, zd);
                    Block block = this.level.m_8055_(target).m_60734_();
                    if (!(block instanceof CropBlock) || !(cropBlock = (CropBlock)block).m_52307_(this.level.m_8055_(target)) || !(this.level.f_46441_.m_188501_() < 0.16f)) continue;
                    this.foundViableCrop = true;
                    this.item = cropBlock.m_7397_((BlockGetter)this.level, target, this.level.m_8055_(target));
                    this.resetCrops(cropBlock, this.level, target, this.level.m_8055_(target));
                    FeywildNetwork.sendParticles(this.level, ParticleMessage.Type.CROPS_RESET, target);
                    return;
                }
            }
        }
    }

    public void resetCrops(CropBlock cropBlock, Level pLevel, BlockPos pPos, BlockState pState) {
        int i = cropBlock.m_52305_(pState);
        if (i != 0) {
            pLevel.m_7731_(pPos, cropBlock.m_52289_(0), 2);
        }
    }

    private void spellCasting() {
        this.entity.setState(PixieBase.State.SPELL_CASTING);
        this.entity.m_5496_((SoundEvent)ModSounds.PIXIE_SPELL_CASTING_SHORT.get(), 0.7f, 1.0f);
    }

    protected void reset() {
        this.entity.setState(PixieBase.State.IDLE);
        this.ticksLeft = -1;
        this.foundViableCrop = false;
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public void m_8056_() {
        this.ticksLeft = 30;
        this.foundViableCrop = false;
    }

    public boolean m_8036_() {
        Player owning = this.entity.getOwningPlayer();
        if (owning instanceof ServerPlayer && this.entity.getAbilityActive().booleanValue()) {
            return this.level.f_46441_.m_188501_() < 0.01f;
        }
        return false;
    }
}

