/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.goals;

import com.saphienyako.feywild.entity.base.PixieBase;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.ParticleMessage;
import com.saphienyako.feywild.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;

public class CropGrowAbilityGoal
extends Goal {
    protected final Level level;
    protected final PixieBase entity;
    protected boolean foundViableCrop;
    private int ticksLeft = 0;

    public CropGrowAbilityGoal(PixieBase entity, Level level) {
        this.level = level;
        this.entity = entity;
    }

    public void m_8037_() {
        if (this.ticksLeft > 0) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                this.reset();
            } else if (this.ticksLeft == 20) {
                this.growCrops(this.entity.m_20183_());
                if (this.foundViableCrop) {
                    this.spellCasting();
                }
            }
        }
    }

    public void m_8056_() {
        this.ticksLeft = 30;
        this.foundViableCrop = false;
    }

    private void reset() {
        this.entity.setState(PixieBase.State.IDLE);
        this.ticksLeft = -1;
        this.foundViableCrop = false;
    }

    private void spellCasting() {
        this.entity.setState(PixieBase.State.SPELL_CASTING);
        this.entity.m_5496_((SoundEvent)ModSounds.PIXIE_SPELL_CASTING_SHORT.get(), 0.7f, 1.0f);
    }

    private void growCrops(BlockPos pos) {
        for (int xd = -8; xd <= 8; ++xd) {
            for (int zd = -8; zd <= 8; ++zd) {
                for (int yd = 8; yd >= -8; --yd) {
                    BlockPos target = pos.m_7918_(xd, yd, zd);
                    if (!(this.level.m_8055_(target).m_60734_() instanceof CropBlock) || !(this.level.f_46441_.m_188501_() < 0.16f)) continue;
                    this.foundViableCrop = true;
                    ((CropBlock)this.level.m_8055_(target).m_60734_()).m_52263_(this.level, target, this.level.m_8055_(target));
                    FeywildNetwork.sendParticles(this.level, ParticleMessage.Type.CROPS_GROW, target);
                }
            }
        }
    }

    public boolean m_8045_() {
        return this.ticksLeft > 0;
    }

    public boolean m_8036_() {
        Player owning = this.entity.getOwningPlayer();
        if (owning instanceof ServerPlayer && this.entity.getAbilityActive().booleanValue()) {
            return this.level.f_46441_.m_188501_() < 0.01f;
        }
        return false;
    }
}

