/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.entity.base;

import com.saphienyako.feywild.config.ModConfig;
import com.saphienyako.feywild.entity.base.FlyingFeyBase;
import com.saphienyako.feywild.entity.goals.IronPanicGoal;
import com.saphienyako.feywild.entity.goals.PanicGoal;
import com.saphienyako.feywild.item.ModItems;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.OpenMenuMessage;
import com.saphienyako.feywild.network.ParticleMessage;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class PixieBase
extends FlyingFeyBase {
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(PixieBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState IDLE_ANIMATION = new AnimationState();
    private int idleAnimationTimeout = 0;
    public final AnimationState SPELL_CASTING_ANIMATION = new AnimationState();
    public int spellCastingAnimationTimeout = 0;

    protected PixieBase(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(50, (Goal)new PanicGoal((LivingEntity)this));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42572_}), false));
        this.f_21345_.m_25352_(40, (Goal)new IronPanicGoal(this, this.m_9236_(), 0.25, 6.0));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.getState().equals((Object)State.IDLE) && this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.IDLE_ANIMATION.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.getState().equals((Object)State.SPELL_CASTING) && this.spellCastingAnimationTimeout <= 0) {
            this.IDLE_ANIMATION.m_216973_();
            this.spellCastingAnimationTimeout = 85;
            this.SPELL_CASTING_ANIMATION.m_216977_(this.f_19797_);
        } else {
            --this.spellCastingAnimationTimeout;
        }
        if (!this.getState().equals((Object)State.SPELL_CASTING)) {
            this.SPELL_CASTING_ANIMATION.m_216973_();
        }
    }

    @Nonnull
    @OverridingMethodsMustInvokeSuper
    public InteractionResult m_7111_(@Nonnull Player player, @Nonnull Vec3 hitVec, @Nonnull InteractionHand hand) {
        InteractionResult superResult = super.m_7111_(player, hitVec, hand);
        if (superResult == InteractionResult.PASS) {
            if (player.m_21120_(hand).m_150930_(Items.f_42572_) && (this.m_21188_() == null || !this.m_21188_().m_6084_())) {
                if (!this.m_9236_().f_46443_) {
                    this.m_5634_(3.0f);
                    if (!this.isTamed() && player instanceof ServerPlayer) {
                        Random random;
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        if (this.owner == null && (random = new Random()).nextInt(6) == 0) {
                            this.m_19983_(new ItemStack((ItemLike)ModItems.FEY_DUST.get()));
                            this.m_216990_(SoundEvents.f_11852_);
                            if (((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue()) {
                                serverPlayer.m_6330_(this.getCookieSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            this.m_146870_();
                            player.m_213846_(this.getFeyCookieMessage());
                        }
                    }
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    FeywildNetwork.sendParticles(this.m_9236_(), ParticleMessage.Type.FEY_HEART, this.m_20097_());
                    player.m_21011_(hand, true);
                }
            } else if (player.m_21120_(hand).m_41720_() == Items.f_42656_) {
                this.m_6593_((Component)player.m_21120_(hand).m_41786_().m_6881_());
                this.m_20340_(true);
                if (!this.m_9236_().f_46443_) {
                    player.m_213846_(this.getFeyNameMessage());
                    if (this.getVoiceActive().booleanValue() && ((Boolean)ModConfig.COMMON.voice_active.get()).booleanValue()) {
                        player.m_6330_(this.getNameSound(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
            } else if (player.m_21120_(hand).m_41720_() == ModItems.PIXIE_ORB.get() && this.isTamed() && player instanceof ServerPlayer && this.owner != null && this.owner.equals(player.m_20148_())) {
                FeywildNetwork.sendToPlayer(new OpenMenuMessage(this.m_7755_(), this.m_19879_(), this.getAlignment(), this.getFollowingPlayer(), this.m_20183_(), this.getAbilityActive(), this.getVoiceActive()), (ServerPlayer)player);
                player.m_21011_(hand, true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return superResult;
    }

    public State getState() {
        State[] states = State.values();
        return states[Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(STATE)), (int)0, (int)(states.length - 1))];
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public static enum State {
        IDLE,
        POSE,
        FLY,
        SPELL_CASTING;

    }
}

