/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.saphienyako.feywild.block.entity.ClientTickHandler;
import com.saphienyako.feywild.block.entity.FeyAltarBlockEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FeyAltarBlockRenderer<T extends FeyAltarBlockEntity>
implements BlockEntityRenderer<FeyAltarBlockEntity> {
    public FeyAltarBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FeyAltarBlockEntity altar, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        ItemStack centerpiece;
        double progressScaled = (double)altar.getProgress() / (double)altar.getMaxProgress();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int lastSlot = altar.getInventory().getSlots() - 1;
        for (int slot = 0; slot < lastSlot; ++slot) {
            ItemStack stack = altar.getInventory().getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        if (!stacks.isEmpty()) {
            double anglePerStack = Math.PI * 2 / (double)stacks.size();
            for (int idx = 0; idx < stacks.size(); ++idx) {
                double shiftX = Math.cos(((double)altar.m_58904_().m_46467_() + (double)partialTick) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                double shiftZ = Math.sin(((double)altar.m_58904_().m_46467_() + (double)partialTick) / 8.0 + (double)idx * anglePerStack) * (1.0 - progressScaled);
                poseStack.m_85836_();
                poseStack.m_85837_(0.5 + shiftX, 1.0 + progressScaled, 0.5 + shiftZ);
                poseStack.m_252781_(Axis.f_252436_.m_252961_(((float)ClientTickHandler.ticksInGame() + partialTick) / 20.0f));
                poseStack.m_85841_(0.85f, 0.85f, 0.85f);
                Minecraft.m_91087_().m_91291_().m_269128_((ItemStack)stacks.get(idx), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, altar.m_58904_(), 0);
                poseStack.m_85849_();
            }
        }
        if (!(centerpiece = altar.getInventory().getStackInSlot(lastSlot)).m_41619_()) {
            poseStack.m_85836_();
            double time = (double)altar.m_58904_().m_46467_() + (double)partialTick;
            double amplitude = 0.1;
            double ShiftY = Math.sin(time / 8.0) * amplitude;
            poseStack.m_85837_(0.5, 2.0 + ShiftY, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(time / 8.0)));
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            Minecraft.m_91087_().m_91291_().m_269128_(centerpiece, ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, poseStack, buffer, altar.m_58904_(), 0);
            poseStack.m_85849_();
        }
    }
}

