/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild.block;

import com.saphienyako.feywild.block.GiantFlowerBlock;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.network.ParticleMessage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DandelionFlowerBlock
extends GiantFlowerBlock {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)3);

    public DandelionFlowerBlock(int height) {
        super(height);
    }

    @Override
    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    @Override
    protected void tickFlower(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)VARIANT) == 3 && level.f_46441_.m_188503_(3) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(2)), 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.replaceFlower(level, pos.m_6630_(3 - (Integer)state.m_61143_((Property)PART)))) {
            if (!level.f_46443_ && player instanceof ServerPlayer) {
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundBlockUpdatePacket((BlockGetter)level, pos));
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private boolean replaceFlower(@Nonnull Level level, @Nonnull BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == this && (Integer)state.m_61143_((Property)PART) == 3 && (Integer)state.m_61143_((Property)VARIANT) == 2) {
            if (!level.f_46443_) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(3)), 3);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_6810_(@Nonnull BlockState oldState, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean moving) {
        super.m_6810_(oldState, level, pos, newState, moving);
        if ((Integer)oldState.m_61143_((Property)VARIANT) == 2) {
            FeywildNetwork.sendParticles(level, ParticleMessage.Type.DANDELION_FLUFF, BlockPos.m_274446_((Position)pos.m_252807_()));
        }
    }

    public float m_5880_(@Nonnull BlockState state, @Nonnull Player player, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        return (Integer)state.m_61143_((Property)PART) == 3 && (Integer)state.m_61143_((Property)VARIANT) == 2 ? 1.0f : super.m_5880_(state, player, level, pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void animateFlower(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.m_61143_((Property)VARIANT) == 2 && random.m_188500_() < 0.4) {
            double windStrength = Math.cos((double)level.m_46467_() / 2000.0) / 8.0;
            double windX = Math.cos((double)level.m_46467_() / 1200.0) * windStrength;
            double windZ = Math.sin((double)level.m_46467_() / 1000.0) * windStrength;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), windX, 0.0, windZ);
        }
    }

    @Override
    public BlockState flowerState(LevelAccessor level, BlockPos pos, RandomSource random) {
        return (BlockState)this.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(random.m_188503_(3)));
    }
}

