/*
 * Decompiled with CFR 0.152.
 */
package com.saphienyako.feywild;

import com.mojang.logging.LogUtils;
import com.saphienyako.feywild.block.ModBlocks;
import com.saphienyako.feywild.block.entity.ModBlockEntities;
import com.saphienyako.feywild.block.renderer.FeyAltarBlockRenderer;
import com.saphienyako.feywild.config.ModConfig;
import com.saphienyako.feywild.effect.ModEffects;
import com.saphienyako.feywild.entity.AutumnPixieEntity;
import com.saphienyako.feywild.entity.ModEntities;
import com.saphienyako.feywild.entity.SpringPixieEntity;
import com.saphienyako.feywild.entity.SummerPixieEntity;
import com.saphienyako.feywild.entity.WinterPixieEntity;
import com.saphienyako.feywild.entity.base.FeyBase;
import com.saphienyako.feywild.entity.model.AutumnPixieModel;
import com.saphienyako.feywild.entity.model.ModModelLayers;
import com.saphienyako.feywild.entity.model.SpringPixieModel;
import com.saphienyako.feywild.entity.model.SummerPixieModel;
import com.saphienyako.feywild.entity.model.WinterPixieModel;
import com.saphienyako.feywild.entity.renderer.AutumnPixieRenderer;
import com.saphienyako.feywild.entity.renderer.SpringPixieRenderer;
import com.saphienyako.feywild.entity.renderer.SummerPixieRenderer;
import com.saphienyako.feywild.entity.renderer.WinterPixieRenderer;
import com.saphienyako.feywild.events.EventListener;
import com.saphienyako.feywild.item.ModCreativeModeTab;
import com.saphienyako.feywild.item.ModItems;
import com.saphienyako.feywild.network.FeywildNetwork;
import com.saphienyako.feywild.particle.LeafParticle;
import com.saphienyako.feywild.particle.ModParticles;
import com.saphienyako.feywild.particle.SparkleParticle;
import com.saphienyako.feywild.recipe.ModRecipes;
import com.saphienyako.feywild.screen.FeyAltarScreen;
import com.saphienyako.feywild.screen.ModMenuTypes;
import com.saphienyako.feywild.sound.ModSounds;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="feywild")
public class Feywild {
    public static final String MOD_ID = "feywild";
    private static Feywild instance;
    private static final Logger LOGGER;

    public Feywild() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entityAttributes);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(this::registerLayer);
            modEventBus.addListener(this::registerParticles);
        });
        ModCreativeModeTab.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModEffects.register(modEventBus);
        ModParticles.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        this.addConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventListener());
    }

    public static Feywild getInstance() {
        return instance;
    }

    private void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)ModEntities.SPRING_PIXIE.get(), SpringPixieEntity.getDefaultAttributes().m_22265_());
        event.put((EntityType)ModEntities.AUTUMN_PIXIE.get(), AutumnPixieEntity.getDefaultAttributes().m_22265_());
        event.put((EntityType)ModEntities.SUMMER_PIXIE.get(), SummerPixieEntity.getDefaultAttributes().m_22265_());
        event.put((EntityType)ModEntities.WINTER_PIXIE.get(), WinterPixieEntity.getDefaultAttributes().m_22265_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModModelLayers.SPRING_PIXIE_LAYER, SpringPixieModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.AUTUMN_PIXIE_LAYER, AutumnPixieModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.SUMMER_PIXIE_LAYER, SummerPixieModel::createBodyLayer);
        event.registerLayerDefinition(ModModelLayers.WINTER_PIXIE_LAYER, WinterPixieModel::createBodyLayer);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(FeywildNetwork::register);
        event.enqueueWork(() -> {
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.MANDRAKE.get()), 2.0f);
            ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.MANDRAKE_ROOT.get()), 0.3f);
        });
    }

    private void addConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_SPEC, "feywild-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.CLIENT_SPEC, "feywild-client.toml");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("THE FEY ARE PLEASED the server is starting");
    }

    public void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.AUTUMN_LEAF_PARTICLE.get(), LeafParticle.Factory::new);
        event.registerSpriteSet((ParticleType)ModParticles.SPRING_SPARKLE_PARTICLE.get(), SparkleParticle.provider(0.0f, 1.0f, 0.0f));
        event.registerSpriteSet((ParticleType)ModParticles.SUMMER_SPARKLE_PARTICLE.get(), SparkleParticle.provider(1.0f, 0.8f, 0.0f));
        event.registerSpriteSet((ParticleType)ModParticles.AUTUMN_SPARKLE_PARTICLE.get(), SparkleParticle.provider(1.0f, 0.4f, 0.0f));
        event.registerSpriteSet((ParticleType)ModParticles.WINTER_SPARKLE_PARTICLE.get(), SparkleParticle.provider(0.2f, 0.8f, 0.9f));
        event.registerSpriteSet((ParticleType)ModParticles.FEY_SPARKLE_PARTICLE.get(), SparkleParticle.provider(0.3f, 0.9f, 0.9f));
    }

    private void spawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ModEntities.SPRING_PIXIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FeyBase::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SUMMER_PIXIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FeyBase::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.AUTUMN_PIXIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FeyBase::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.WINTER_PIXIE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FeyBase::canSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    @Mod.EventBusSubscriber(modid="feywild", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("AND A LITTLE BIT OF PIXIE DUST!");
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SPRING_PIXIE.get()), SpringPixieRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.AUTUMN_PIXIE.get()), AutumnPixieRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.SUMMER_PIXIE.get()), SummerPixieRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)ModEntities.WINTER_PIXIE.get()), WinterPixieRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)ModBlockEntities.FEY_ALTAR_BLOCK_ENTITY.get()), FeyAltarBlockRenderer::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FEY_ALTAR_MENU.get()), FeyAltarScreen::new);
        }
    }
}

