/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksitems.entity;

import de.markusbordihn.adaptiveperformancetweakscore.CoreConstants;
import de.markusbordihn.adaptiveperformancetweaksitems.config.CommonConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class ExperienceOrbManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Items)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static Map<String, Set<ExperienceOrb>> experienceOrbEntityMap = new ConcurrentHashMap<String, Set<ExperienceOrb>>();

    protected ExperienceOrbManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        experienceOrbEntityMap = new ConcurrentHashMap<String, Set<ExperienceOrb>>();
        if (Boolean.TRUE.equals(ExperienceOrbManager.COMMON.optimizeExperienceOrbs.get())) {
            log.info("Enable clustering of Experience Orbs with a radius of {} blocks.", ExperienceOrbManager.COMMON.experienceOrbsClusterRange.get());
            if (CoreConstants.CLUMPS_LOADED) {
                log.error("WARNING: Clumps groups XP orbs together into a new single entity, which will conflict with the XP Orb feature of this mod!");
                log.warn("Don't use both optimizations together! Clustering of Experience Orbs will be automatically disabled!");
            }
        } else {
            log.info("Disable Experience Orbs clustering ...");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleExperienceOrbJoinWorldEvent(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        if (level.f_46443_ || event.isCanceled()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ExperienceOrb)) {
            return;
        }
        ExperienceOrb experienceOrbEntity = (ExperienceOrb)entity;
        if (event.isCanceled()) {
            return;
        }
        String levelName = level.m_46472_().m_135782_().toString();
        if (Boolean.TRUE.equals((Boolean)ExperienceOrbManager.COMMON.optimizeExperienceOrbs.get() != false && !CoreConstants.CLUMPS_LOADED) && experienceOrbEntity.f_20770_ <= 0) {
            log.debug("Remove Experience Orb {} with {} xp from {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.f_20770_, (Object)levelName);
            experienceOrbEntity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        log.debug("Experience Orb {} with {} xp joined {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.f_20770_, (Object)levelName);
        experienceOrbEntityMap.computeIfAbsent(levelName, k -> new LinkedHashSet());
        Set<ExperienceOrb> experienceOrbWorldEntities = experienceOrbEntityMap.get(levelName);
        if (Boolean.TRUE.equals((Boolean)ExperienceOrbManager.COMMON.optimizeExperienceOrbs.get() != false && !CoreConstants.CLUMPS_LOADED) && !experienceOrbWorldEntities.isEmpty()) {
            HashSet<ExperienceOrb> experienceOrbsEntities = new HashSet<ExperienceOrb>(experienceOrbWorldEntities);
            Iterator experienceOrbsEntitiesIterator = experienceOrbsEntities.iterator();
            int x = (int)experienceOrbEntity.m_20185_();
            int y = (int)experienceOrbEntity.m_20186_();
            int z = (int)experienceOrbEntity.m_20189_();
            int experienceOrbsClusterRange = (Integer)ExperienceOrbManager.COMMON.experienceOrbsClusterRange.get();
            int xStart = x - experienceOrbsClusterRange;
            int yStart = y - experienceOrbsClusterRange;
            int zStart = z - experienceOrbsClusterRange;
            int xEnd = x + experienceOrbsClusterRange;
            int yEnd = y + experienceOrbsClusterRange;
            int zEnd = z + experienceOrbsClusterRange;
            while (experienceOrbsEntitiesIterator.hasNext()) {
                ExperienceOrb existingExperienceOrb = (ExperienceOrb)experienceOrbsEntitiesIterator.next();
                int xSub = (int)existingExperienceOrb.m_20185_();
                int ySub = (int)existingExperienceOrb.m_20186_();
                int zSub = (int)existingExperienceOrb.m_20189_();
                if (experienceOrbEntity.m_19879_() == existingExperienceOrb.m_19879_() || !existingExperienceOrb.m_6084_() || xStart >= xSub || xSub >= xEnd || yStart >= ySub || ySub >= yEnd || zStart >= zSub || zSub >= zEnd) continue;
                int newExperienceValue = existingExperienceOrb.f_20770_ + experienceOrbEntity.f_20770_;
                log.debug("Merge experience orb {} with {} and {} xp.", (Object)experienceOrbEntity, (Object)existingExperienceOrb, (Object)newExperienceValue);
                existingExperienceOrb.f_20770_ = newExperienceValue;
                experienceOrbEntity.f_20770_ = 0;
                experienceOrbEntity.m_6027_(existingExperienceOrb.m_20185_(), existingExperienceOrb.m_20186_(), existingExperienceOrb.m_20189_());
                experienceOrbEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                event.setCanceled(true);
                return;
            }
        }
        experienceOrbWorldEntities.add(experienceOrbEntity);
    }

    @SubscribeEvent
    public static void handleExperienceOrbLeaveWorldEvent(EntityLeaveLevelEvent event) {
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof ExperienceOrb)) {
            return;
        }
        ExperienceOrb experienceOrbEntity = (ExperienceOrb)entity;
        String levelName = level.m_46472_().m_135782_().toString();
        log.debug("Experience Orb {} with {} xp left {}.", (Object)experienceOrbEntity, (Object)experienceOrbEntity.f_20770_, (Object)levelName);
        Set<ExperienceOrb> experienceOrbWorldEntities = experienceOrbEntityMap.get(levelName);
        if (experienceOrbWorldEntities != null) {
            experienceOrbWorldEntities.remove(experienceOrbEntity);
            if (experienceOrbWorldEntities.isEmpty()) {
                experienceOrbEntityMap.remove(levelName);
            }
        }
    }
}

