/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.SimpleBlockPredicate;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LargeFumaroleFeature
extends Feature<NoneFeatureConfiguration> {
    protected SimpleBlockPredicate placeOn = (world, pos) -> world.m_8055_(pos).m_60734_() == BOPBlocks.BRIMSTONE.get();
    protected SimpleBlockPredicate replace = (world, pos) -> TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos) || world.m_8055_(pos).m_60734_() == BOPBlocks.BRIMSTONE_BUD.get() || world.m_8055_(pos).m_60734_() == BOPBlocks.BRIMSTONE_CLUSTER.get();

    public LargeFumaroleFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        ChunkGenerator chunkGenerator = featurePlaceContext.m_159775_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos pos = featurePlaceContext.m_159777_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.m_159778_();
        if (!world.m_46859_(pos)) {
            return false;
        }
        if (!this.placeOn.matches(world, pos.m_7495_())) {
            return false;
        }
        int height = -1 + rand.m_188503_(3);
        int radius = 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (height > -1) {
                    for (int y = 0; y <= height; ++y) {
                        this.setBlock(world, pos.m_7918_(x, y, z), ((Block)BOPBlocks.BRIMSTONE.get()).m_49966_());
                    }
                }
                if (!(x != -radius && x != radius || z != -radius && z != radius)) {
                    if (height <= -1) continue;
                    this.setBlock(world, pos.m_7918_(x, height + 1, z), ((Block)BOPBlocks.BRIMSTONE_BUD.get()).m_49966_());
                    continue;
                }
                this.setBlock(world, pos.m_7918_(x, -1, z), ((Block)BOPBlocks.BRIMSTONE.get()).m_49966_());
                this.setBlock(world, pos.m_7918_(x, height + 1, z), ((Block)BOPBlocks.BRIMSTONE.get()).m_49966_());
                this.setBlock(world, pos.m_7918_(x, height + 2, z), ((Block)BOPBlocks.BRIMSTONE_BUD.get()).m_49966_());
            }
        }
        this.setBlock(world, pos.m_7918_(0, height + 2, 0), ((Block)BOPBlocks.BRIMSTONE.get()).m_49966_());
        this.setBlock(world, pos.m_6630_(height + 3), ((Block)BOPBlocks.BRIMSTONE_FUMAROLE.get()).m_49966_());
        return true;
    }

    public boolean setBlock(WorldGenLevel world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.m_5974_((LevelWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(WorldGenLevel world, BlockPos pos) {
        for (int y = 0; y <= 4; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.m_7918_(x, y, z);
                    if (pos1.m_123342_() < 255 && this.replace.matches(world, pos1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

