/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import fuzs.moblassos.MobLassos;
import fuzs.moblassos.capability.VillagerContractCapability;
import fuzs.moblassos.init.ModRegistry;
import fuzs.moblassos.network.ClientboundVillagerContractMessage;
import fuzs.moblassos.network.ClientboundVillagerParticlesMessage;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ContractItem
extends Item {
    public ContractItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ContractItem && entity instanceof AbstractVillager) {
            AbstractVillager abstractVillager = (AbstractVillager)entity;
            if (entity.m_6084_()) {
                Component displayName;
                if (abstractVillager instanceof Villager) {
                    Villager villager = (Villager)abstractVillager;
                    MutableComponent merchantLevel = Component.m_237115_((String)("merchant.level." + villager.m_7141_().m_35576_()));
                    displayName = Component.m_237119_().m_7220_(entity.m_5446_()).m_130946_(" (").m_7220_((Component)merchantLevel).m_130946_(")");
                } else {
                    displayName = entity.m_5446_();
                }
                if (VillagerContractCapability.canAcceptContract(abstractVillager)) {
                    return ModRegistry.VILLAGER_CONTRACT_CAPABILITY.maybeGet((Object)entity).filter(Predicate.not(VillagerContractCapability::hasAcceptedContract)).map(capability -> {
                        capability.acceptContract();
                        if (!level.f_46443_) {
                            if (!player.m_150110_().f_35937_) {
                                stack.m_41774_(1);
                            }
                            MobLassos.NETWORKING.sendToAllTracking(entity, (Record)new ClientboundVillagerParticlesMessage(entity.m_19879_(), true));
                        }
                        abstractVillager.m_7713_(stack);
                        player.m_5661_((Component)Component.m_237110_((String)(((Item)ModRegistry.CONTRACT_ITEM.get()).m_5524_() + ".accept"), (Object[])new Object[]{displayName}).m_130940_(ChatFormatting.GREEN), true);
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }).or(() -> Optional.of(InteractionResult.CONSUME_PARTIAL)).map(EventResultHolder::interrupt).orElseGet(EventResultHolder::pass);
                }
                if (!level.f_46443_) {
                    MobLassos.NETWORKING.sendToAllTracking(entity, (Record)new ClientboundVillagerParticlesMessage(entity.m_19879_(), false));
                }
                ContractItem.setVillagerUnhappy(abstractVillager);
                abstractVillager.m_7713_(ItemStack.f_41583_);
                player.m_5661_((Component)Component.m_237110_((String)(((Item)ModRegistry.CONTRACT_ITEM.get()).m_5524_() + ".reject"), (Object[])new Object[]{displayName}).m_130940_(ChatFormatting.RED), true);
                return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
            }
        }
        return EventResultHolder.pass();
    }

    private static void setVillagerUnhappy(AbstractVillager villager) {
        villager.m_35319_(40);
        if (!villager.m_9236_().m_5776_()) {
            villager.m_5496_(SoundEvents.f_12507_, 1.0f, villager.m_6100_());
        }
    }

    public static EventResult onEntityJoinServerLevel(Entity entity, ServerLevel level, @Nullable MobSpawnType spawnType) {
        if (entity instanceof AbstractVillager && ModRegistry.VILLAGER_CONTRACT_CAPABILITY.maybeGet((Object)entity).filter(VillagerContractCapability::hasAcceptedContract).isPresent()) {
            MobLassos.NETWORKING.sendToAllTracking(entity, (Record)new ClientboundVillagerContractMessage(entity.m_19879_()));
        }
        return EventResult.PASS;
    }

    public static void addParticlesAroundVillager(@Nullable AbstractVillager villager, ParticleOptions particleOption) {
        if (villager != null) {
            for (int i = 0; i < 5; ++i) {
                double d0 = villager.m_217043_().m_188583_() * 0.02;
                double d1 = villager.m_217043_().m_188583_() * 0.02;
                double d2 = villager.m_217043_().m_188583_() * 0.02;
                villager.m_9236_().m_7106_(particleOption, villager.m_20208_(1.0), villager.m_20187_() + 1.0, villager.m_20262_(1.0), d0, d1, d2);
            }
        }
    }
}

