/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.block.AcceleratorBlock;
import com.cyanogen.experienceobelisk.block_entities.AbstractAcceleratorEntity;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AcceleratorEntity
extends AbstractAcceleratorEntity {
    static final double orbSpeed = 2.0;
    static final double entitySpeed = 1.3;

    public AcceleratorEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RegisterBlockEntities.ACCELERATOR_BE.get(), pos, state);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof AcceleratorEntity) {
            AcceleratorEntity accelerator = (AcceleratorEntity)((Object)blockEntity);
            if (!accelerator.redstoneEnabled || level.m_276867_(pos)) {
                if (!((Boolean)state.m_61143_((Property)AcceleratorBlock.ACTIVE)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)AcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                    level.m_46597_(pos, state);
                }
                Direction facing = (Direction)state.m_61143_((Property)AcceleratorBlock.FACING);
                int x = 0;
                int y = 0;
                int z = 0;
                switch (facing) {
                    case UP: {
                        y = 1;
                        break;
                    }
                    case DOWN: {
                        y = -1;
                        break;
                    }
                    case NORTH: {
                        z = -1;
                        break;
                    }
                    case SOUTH: {
                        z = 1;
                        break;
                    }
                    case EAST: {
                        x = 1;
                        break;
                    }
                    case WEST: {
                        x = -1;
                    }
                }
                AABB area = new AABB((double)(pos.m_123341_() + x), (double)(pos.m_123342_() + y), (double)(pos.m_123343_() + z), (double)(pos.m_123341_() + 1 + x), (double)(pos.m_123342_() + 1 + y), (double)(pos.m_123343_() + 1 + z));
                List list = level.m_45933_(null, area);
                if (!list.isEmpty()) {
                    for (Entity entity : list) {
                        Player player;
                        boolean isShiftPlayer;
                        boolean bl = isShiftPlayer = entity instanceof Player && (player = (Player)entity).m_6144_();
                        if (entity instanceof ExperienceOrb) {
                            ExperienceOrb orb = (ExperienceOrb)entity;
                            orb.m_246865_(new Vec3(2.0 * (double)x, 2.0 * (double)y, 2.0 * (double)z));
                            continue;
                        }
                        if (isShiftPlayer) continue;
                        double yVelocity = entity.m_20184_().m_7098_();
                        entity.m_246865_(new Vec3(1.3 * (double)x, 1.3 * (double)y - yVelocity, 1.3 * (double)z));
                    }
                }
            } else if (((Boolean)state.m_61143_((Property)AcceleratorBlock.ACTIVE)).booleanValue()) {
                state = (BlockState)state.m_61124_((Property)AcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
                level.m_46597_(pos, state);
            }
        }
    }
}

