/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block;

import com.cyanogen.experienceobelisk.block.ExperienceReceivingBlock;
import com.cyanogen.experienceobelisk.block_entities.ExperienceFountainEntity;
import com.cyanogen.experienceobelisk.block_entities.ExperienceObeliskEntity;
import com.cyanogen.experienceobelisk.recipe.EmptyingRecipe;
import com.cyanogen.experienceobelisk.recipe.FillingRecipe;
import com.cyanogen.experienceobelisk.registries.RegisterBlockEntities;
import com.cyanogen.experienceobelisk.registries.RegisterFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperienceFountainBlock
extends ExperienceReceivingBlock
implements EntityBlock {
    public ExperienceFountainBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(9.0f).m_155954_(1.2f).m_155956_(9.0f).m_60955_().m_60918_(SoundType.f_56743_));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (super.m_6227_(state, level, pos, player, hand, hit) != InteractionResult.PASS) {
            return InteractionResult.CONSUME;
        }
        BlockEntity entity = level.m_7702_(pos);
        ItemStack heldItem = player.m_21120_(hand);
        @Nullable IFluidHandlerItem fluidHandler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1)).orElse(null);
        if (entity instanceof ExperienceFountainEntity) {
            BlockEntity blockEntity;
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)entity;
            if (fountain.isBound && (blockEntity = level.m_7702_(fountain.getBoundPos())) instanceof ExperienceObeliskEntity) {
                ExperienceObeliskEntity obelisk = (ExperienceObeliskEntity)blockEntity;
                if (fluidHandler != null) {
                    this.handleExperienceContainer(heldItem, fluidHandler, player, hand, obelisk);
                    return InteractionResult.m_19078_((boolean)true);
                }
                FillingRecipe fillingRecipe = FillingRecipe.getRecipe(level, heldItem);
                if (fillingRecipe != null) {
                    this.handleFillingRecipe(heldItem, fillingRecipe, player, hand, obelisk, false);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                EmptyingRecipe emptyingRecipe = EmptyingRecipe.getRecipe(level, heldItem);
                if (emptyingRecipe != null) {
                    this.handleEmptyingRecipe(heldItem, emptyingRecipe, player, hand, obelisk, false);
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
            }
            fountain.cycleActivityState();
            MutableComponent message = ExperienceFountainBlock.getMutableComponent(fountain);
            player.m_5661_((Component)message, true);
            level.m_7260_(pos, state, state, 2);
        }
        if (!level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private static MutableComponent getMutableComponent(ExperienceFountainEntity fountain) {
        MutableComponent message = Component.m_237119_();
        switch (fountain.getActivityState()) {
            case 0: {
                message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.slow");
                break;
            }
            case 1: {
                message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.moderate");
                break;
            }
            case 2: {
                message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.fast");
                break;
            }
            case 3: {
                message = Component.m_237115_((String)"message.experienceobelisk.experience_fountain.hyper");
            }
        }
        return message;
    }

    public void handleExperienceContainer(ItemStack heldItem, IFluidHandlerItem fluidHandler, Player player, InteractionHand hand, ExperienceObeliskEntity obelisk) {
        FluidStack cognitium = new FluidStack((Fluid)RegisterFluids.COGNITIUM.get(), 1000);
        if (obelisk.getFluidAmount() >= 1000 && fluidHandler.fill(cognitium, IFluidHandler.FluidAction.SIMULATE) >= 1000) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                fluidHandler.fill(cognitium, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fluidItem = fluidHandler.getContainer();
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, fluidItem);
                } else if (!player.m_36356_(fluidItem)) {
                    player.m_36176_(fluidItem, false);
                }
            }
            obelisk.drain(1000);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
        } else if (obelisk.getSpace() >= 1000 && fluidHandler.drain(cognitium, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 1000) {
            if (!player.m_7500_()) {
                heldItem.m_41774_(1);
                fluidHandler.drain(cognitium, IFluidHandler.FluidAction.EXECUTE);
                ItemStack fluidItem = fluidHandler.getContainer();
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, fluidItem);
                } else if (!player.m_36356_(fluidItem)) {
                    player.m_36176_(fluidItem, false);
                }
            }
            obelisk.fill(1000);
            player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleFillingRecipe(ItemStack heldItem, FillingRecipe recipe, Player player, InteractionHand hand, ExperienceObeliskEntity obelisk, boolean shiftKeyDown) {
        int drainAmount = recipe.getCognitiumCost();
        ItemStack result = recipe.m_8043_(null);
        int resultCount = result.m_41613_();
        if (!shiftKeyDown) {
            if (obelisk.getFluidAmount() < drainAmount) return;
            obelisk.drain(drainAmount);
            heldItem.m_41774_(1);
        } else {
            int maxDrainCount = obelisk.getFluidAmount() / drainAmount;
            if (obelisk.getFluidAmount() < drainAmount) {
                return;
            }
            if (maxDrainCount >= heldItem.m_41613_()) {
                obelisk.drain(drainAmount * heldItem.m_41613_());
                resultCount = result.m_41613_() * heldItem.m_41613_();
                heldItem.m_41764_(0);
            } else {
                obelisk.drain(drainAmount * maxDrainCount);
                resultCount = result.m_41613_() * maxDrainCount;
                heldItem.m_41774_(maxDrainCount);
            }
        }
        result.m_41764_(resultCount);
        if (heldItem.m_41619_() && result.m_41613_() <= result.m_41741_()) {
            player.m_21008_(hand, result);
        } else if (!player.m_36356_(result)) {
            player.m_36176_(result, false);
        }
        player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEmptyingRecipe(ItemStack heldItem, EmptyingRecipe recipe, Player player, InteractionHand hand, ExperienceObeliskEntity obelisk, boolean shiftKeyDown) {
        int fillAmount = recipe.getCognitiumGain();
        ItemStack result = recipe.hasResultStack() ? recipe.m_8043_(null) : ItemStack.f_41583_;
        int resultCount = result.m_41613_();
        if (!shiftKeyDown) {
            if (obelisk.getSpace() < fillAmount) return;
            obelisk.fill(fillAmount);
            heldItem.m_41774_(1);
        } else {
            int maxFillCount = obelisk.getSpace() / fillAmount;
            if (obelisk.getSpace() < fillAmount) {
                return;
            }
            if (maxFillCount >= heldItem.m_41613_()) {
                obelisk.fill(fillAmount * heldItem.m_41613_());
                resultCount = result.m_41613_() * heldItem.m_41613_();
                heldItem.m_41764_(0);
            } else {
                obelisk.fill(fillAmount * maxFillCount);
                resultCount = result.m_41613_() * maxFillCount;
                heldItem.m_41774_(maxFillCount);
            }
        }
        if (recipe.hasResultStack()) {
            result.m_41764_(resultCount);
            if (heldItem.m_41619_() && result.m_41613_() <= result.m_41741_()) {
                player.m_21008_(hand, result);
            } else if (!player.m_36356_(result)) {
                player.m_36176_(result, false);
            }
        }
        player.m_5496_(SoundEvents.f_11769_, 1.0f, 1.0f);
    }

    public static void handleExperienceItemStack(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack heldItem = player.m_21120_(hand);
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ExperienceFountainEntity) {
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)blockEntity;
            if (fountain.isBound && fountain.getBoundObelisk() != null && !heldItem.m_41619_() && event.getEntity().m_6144_()) {
                ExperienceFountainBlock block = (ExperienceFountainBlock)level.m_8055_(pos).m_60734_();
                FillingRecipe fillingRecipe = FillingRecipe.getRecipe(level, heldItem);
                if (fillingRecipe != null) {
                    block.handleFillingRecipe(heldItem, fillingRecipe, player, hand, fountain.getBoundObelisk(), true);
                    event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                    event.setCanceled(true);
                } else {
                    EmptyingRecipe emptyingRecipe = EmptyingRecipe.getRecipe(level, heldItem);
                    if (emptyingRecipe != null) {
                        block.handleEmptyingRecipe(heldItem, emptyingRecipe, player, hand, fountain.getBoundObelisk(), true);
                        event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape center = Shapes.m_83064_((AABB)new AABB(0.28125, 0.0, 0.28125, 0.71875, 0.53125, 0.71875));
        VoxelShape shape1 = Shapes.m_83064_((AABB)new AABB(0.125, 0.08125, 0.2875, 0.875, 0.14375, 0.7125));
        VoxelShape shape2 = Shapes.m_83064_((AABB)new AABB(0.2875, 0.08125, 0.125, 0.7125, 0.14375, 0.875));
        return Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)center, (VoxelShape)shape1, (BooleanOp)BooleanOp.f_82695_), (VoxelShape)shape2, (BooleanOp)BooleanOp.f_82695_).m_83296_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        BlockEntity entity = getter.m_7702_(pos);
        if (entity instanceof ExperienceFountainEntity) {
            Level level;
            ExperienceFountainEntity fountain = (ExperienceFountainEntity)entity;
            if (fountain.isBound && ((level = fountain.m_58904_()) != null && level.m_276867_(pos) || fountain.hasPlayerAbove)) {
                return 7;
            }
        }
        return 0;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == RegisterBlockEntities.EXPERIENCE_FOUNTAIN_BE.get() ? ExperienceFountainEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)RegisterBlockEntities.EXPERIENCE_FOUNTAIN_BE.get()).m_155264_(pos, state);
    }
}

