/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.spawn;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnerManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Spawn)");
    static final Set<BaseSpawner> spawnerList = ConcurrentHashMap.newKeySet();
    private static final short VERIFICATION_TICK = 1200;
    private static short ticks = 0;

    protected SpawnerManager() {
    }

    @SubscribeEvent
    public static void handleClientServerTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            short s = ticks;
            ticks = (short)(s + 1);
            if (s >= 1200) {
                SpawnerManager.verifyEntities();
                ticks = 0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handleFinalizeSpawnEvent(MobSpawnEvent.FinalizeSpawn event) {
        ServerLevelAccessor level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity == null || entity instanceof Projectile) {
            return;
        }
        if (event.getSpawner() != null) {
            if (event.isCanceled() || event.getResult() == Event.Result.DENY) {
                return;
            }
            BaseSpawner spawner = event.getSpawner();
            SpawnerManager.addSpawner(spawner);
        }
    }

    public static void addSpawner(BaseSpawner spawner) {
        BlockEntity blockEntity;
        if (spawnerList.contains(spawner)) {
            return;
        }
        spawnerList.add(spawner);
        if (log.isDebugEnabled() && (blockEntity = spawner.getSpawnerBlockEntity()) != null) {
            BlockPos blockPos = blockEntity.m_58899_();
            Level level = blockEntity.m_58904_();
            String levelName = level != null ? level.m_46472_().m_135782_().toString() : "";
            CompoundTag spawnerData = blockEntity.serializeNBT();
            String spawnerId = spawnerData.m_128461_("id");
            String spawnEntityId = spawnerData.m_128469_("SpawnData").m_128469_("entity").m_128461_("id");
            log.debug("[Spawner] Found {}({}) at {} in {}", (Object)spawnerId, (Object)spawnEntityId, (Object)blockPos, (Object)levelName);
        }
    }

    public static Set<BaseSpawner> getSpawnerList() {
        return spawnerList;
    }

    public static void verifyEntities() {
        int removedEntries = 0;
        Iterator<BaseSpawner> spawnerIterator = spawnerList.iterator();
        while (spawnerIterator.hasNext()) {
            BlockEntity spawnerBlockEntity;
            BaseSpawner spawner = spawnerIterator.next();
            BlockEntity blockEntity = spawnerBlockEntity = spawner != null ? spawner.getSpawnerBlockEntity() : null;
            if (spawner != null && spawnerBlockEntity != null && !spawnerBlockEntity.m_58901_()) continue;
            spawnerIterator.remove();
            ++removedEntries;
        }
        if (removedEntries > 0) {
            log.debug("Removed {} entries during the verification", (Object)removedEntries);
        }
    }
}

