/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.spawn;

import de.markusbordihn.adaptiveperformancetweaksspawn.config.CommonConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.AlexsMobsSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.AquacultureSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.BornInChaosSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.CustomSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.ExoticBirdsSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.FishOfThievesSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.FriendsAndFoesSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.GothicSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.InfernalExpansionSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.MekanismAdditionsSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.MinecraftSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.NetherSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.PanthalassaSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.QuarkSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.TinkersConstructConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.UntamedWildsSpawnConfig;
import de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn.UntitledDuckSpawnConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class SpawnConfigManager {
    protected static final Logger log = LogManager.getLogger((String)"APTweaks(Spawn)");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final AlexsMobsSpawnConfig.Config ALEXS_MOBS_CONFIG = AlexsMobsSpawnConfig.COMMON;
    private static final AquacultureSpawnConfig.Config AQUACULTURE_CONFIG = AquacultureSpawnConfig.COMMON;
    private static final BornInChaosSpawnConfig.Config BORN_IN_CHAOS_CONFIG = BornInChaosSpawnConfig.COMMON;
    private static final CustomSpawnConfig.Config CUSTOM_CONFIG = CustomSpawnConfig.COMMON;
    private static final ExoticBirdsSpawnConfig.Config EXOTIC_BIRDS_CONFIG = ExoticBirdsSpawnConfig.COMMON;
    private static final FishOfThievesSpawnConfig.Config FISH_OF_THIEVES_CONFIG = FishOfThievesSpawnConfig.COMMON;
    private static final FriendsAndFoesSpawnConfig.Config FRIENDS_AND_FOES_CONFIG = FriendsAndFoesSpawnConfig.COMMON;
    private static final GothicSpawnConfig.Config GOTHIC_CONFIG = GothicSpawnConfig.COMMON;
    private static final InfernalExpansionSpawnConfig.Config INFERNAL_EXPANSION_CONFIG = InfernalExpansionSpawnConfig.COMMON;
    private static final MekanismAdditionsSpawnConfig.Config MEKANISM_ADDITIONS_CONFIG = MekanismAdditionsSpawnConfig.COMMON;
    private static final MinecraftSpawnConfig.Config MINECRAFT_CONFIG = MinecraftSpawnConfig.COMMON;
    private static final NetherSpawnConfig.Config NETHER_CONFIG = NetherSpawnConfig.COMMON;
    private static final PanthalassaSpawnConfig.Config PANTHALASSA_CONFIG = PanthalassaSpawnConfig.COMMON;
    private static final QuarkSpawnConfig.Config QUARK_CONFIG = QuarkSpawnConfig.COMMON;
    private static final TinkersConstructConfig.Config TINKERS_CONSTRUCT_CONFIG = TinkersConstructConfig.COMMON;
    private static final UntamedWildsSpawnConfig.Config UNTAMED_WILDS_CONFIG = UntamedWildsSpawnConfig.COMMON;
    private static final UntitledDuckSpawnConfig.Config UNTITLED_DUCK_CONFIG = UntitledDuckSpawnConfig.COMMON;
    private static final Map<String, Integer> spawnConfigPerPlayer = new HashMap<String, Integer>();
    private static final Map<String, Integer> spawnConfigPerWorld = new HashMap<String, Integer>();
    private static final Map<String, Integer> spawnConfigPerServer = new HashMap<String, Integer>();
    private static final Map<String, Integer> spawnConfigSpecial = new HashMap<String, Integer>();

    protected SpawnConfigManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        SpawnConfigManager.clearSpawnRates();
        SpawnConfigManager.calculateSpawnRates();
    }

    public static void calculateSpawnRates() {
        ModList modList = ModList.get();
        if (Boolean.TRUE.equals(SpawnConfigManager.MINECRAFT_CONFIG.enabled.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.hostileMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.NETHER_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.NETHER_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.NETHER_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.NETHER_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.NETHER_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.NETHER_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.NETHER_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.NETHER_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.NETHER_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.NETHER_CONFIG.hostileMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.waterPassiveMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterPassiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterPassiveMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterPassiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.waterNeutralMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterNeutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterNeutralMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterNeutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.MINECRAFT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MINECRAFT_CONFIG.waterHostileMobsList.get()), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterHostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterHostileMobsPerWorld.get(), (Integer)SpawnConfigManager.MINECRAFT_CONFIG.waterHostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.AQUACULTURE_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.AQUACULTURE_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.AQUACULTURE_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.AQUACULTURE_CONFIG.fishList.get()), (Integer)SpawnConfigManager.AQUACULTURE_CONFIG.fishPerPlayer.get(), (Integer)SpawnConfigManager.AQUACULTURE_CONFIG.fishPerWorld.get(), (Integer)SpawnConfigManager.AQUACULTURE_CONFIG.fishPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.BORN_IN_CHAOS_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.BORN_IN_CHAOS_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.ALEXS_MOBS_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.ALEXS_MOBS_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.ALEXS_MOBS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.ALEXS_MOBS_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.ALEXS_MOBS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.ALEXS_MOBS_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.ALEXS_MOBS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.ALEXS_MOBS_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.ALEXS_MOBS_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.FISH_OF_THIEVES_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.fishList.get()), (Integer)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.fishPerPlayer.get(), (Integer)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.fishPerWorld.get(), (Integer)SpawnConfigManager.FISH_OF_THIEVES_CONFIG.fishPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.FRIENDS_AND_FOES_CONFIG.passiveMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.EXOTIC_BIRDS_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.EXOTIC_BIRDS_CONFIG.passiveMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.GOTHIC_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.GOTHIC_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.GOTHIC_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.GOTHIC_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.GOTHIC_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.GOTHIC_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.GOTHIC_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.GOTHIC_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.GOTHIC_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.GOTHIC_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.GOTHIC_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.GOTHIC_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.INFERNAL_EXPANSION_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.MEKANISM_ADDITIONS_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.PANTHALASSA_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.PANTHALASSA_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.PANTHALASSA_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.PANTHALASSA_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.PANTHALASSA_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.PANTHALASSA_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.PANTHALASSA_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.PANTHALASSA_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.PANTHALASSA_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.QUARK_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.QUARK_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.QUARK_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.QUARK_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.QUARK_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.QUARK_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.QUARK_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.QUARK_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.QUARK_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.QUARK_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.QUARK_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.QUARK_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.TINKERS_CONSTRUCT_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.UNTAMED_WILDS_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.UNTAMED_WILDS_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.UNTAMED_WILDS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.UNTAMED_WILDS_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.UNTAMED_WILDS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.UNTAMED_WILDS_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.UNTAMED_WILDS_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.UNTAMED_WILDS_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.UNTAMED_WILDS_CONFIG.hostileMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.UNTITLED_DUCK_CONFIG.enabled.get()) && modList.isLoaded((String)SpawnConfigManager.UNTITLED_DUCK_CONFIG.id.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.UNTITLED_DUCK_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.UNTITLED_DUCK_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.UNTITLED_DUCK_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.UNTITLED_DUCK_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.UNTITLED_DUCK_CONFIG.neutralMobsPerServer.get());
        }
        if (Boolean.TRUE.equals(SpawnConfigManager.CUSTOM_CONFIG.enabled.get())) {
            SpawnConfigManager.addSpawnRatesForPassiveMobs((String)SpawnConfigManager.CUSTOM_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.CUSTOM_CONFIG.passiveMobsList.get()), (Integer)SpawnConfigManager.CUSTOM_CONFIG.passiveMobsPerPlayer.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.passiveMobsPerWorld.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.passiveMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForNeutralMobs((String)SpawnConfigManager.CUSTOM_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.CUSTOM_CONFIG.neutralMobsList.get()), (Integer)SpawnConfigManager.CUSTOM_CONFIG.neutralMobsPerPlayer.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.neutralMobsPerWorld.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.neutralMobsPerServer.get());
            SpawnConfigManager.addSpawnRatesForHostileMobs((String)SpawnConfigManager.CUSTOM_CONFIG.id.get(), new HashSet<String>((Collection)SpawnConfigManager.CUSTOM_CONFIG.hostileMobsList.get()), (Integer)SpawnConfigManager.CUSTOM_CONFIG.hostileMobsPerPlayer.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.hostileMobsPerWorld.get(), (Integer)SpawnConfigManager.CUSTOM_CONFIG.hostileMobsPerServer.get());
        }
        log.info("Added {} player spawn rules, {} world spawn rules and {} special spawn rules.", (Object)spawnConfigPerPlayer.size(), (Object)spawnConfigPerWorld.size(), (Object)spawnConfigSpecial.size());
    }

    public static void clearSpawnRates() {
        log.info("Clearing spawn rates calculation ...");
        spawnConfigPerPlayer.clear();
        spawnConfigPerWorld.clear();
        spawnConfigSpecial.clear();
    }

    public static boolean hasSpawnLimit(String entityName) {
        return spawnConfigPerPlayer.containsKey(entityName) || spawnConfigPerWorld.containsKey(entityName);
    }

    public static void addSpawnConfigPerPlayer(String entityName, int maxNumberOfEntities) {
        spawnConfigPerPlayer.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigPerWorld(String entityName, int maxNumberOfEntities) {
        spawnConfigPerWorld.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigPerServer(String entityName, int maxNumberOfEntities) {
        spawnConfigPerServer.put(entityName, maxNumberOfEntities);
    }

    public static void addSpawnConfigSpecial(String entityName, int maxNumberOfEntities) {
        spawnConfigSpecial.put(entityName, maxNumberOfEntities);
    }

    public static int getSpawnLimitPerPlayer(String entityName) {
        return spawnConfigPerPlayer.getOrDefault(entityName, (Integer)SpawnConfigManager.COMMON.spawnLimitationMaxMobsPerPlayer.get());
    }

    public static int getSpawnLimitPerWorld(String entityName) {
        return spawnConfigPerWorld.getOrDefault(entityName, (Integer)SpawnConfigManager.COMMON.spawnLimitationMaxMobsPerWorld.get());
    }

    public static int getSpawnLimitPerServer(String entityName) {
        return spawnConfigPerServer.getOrDefault(entityName, (Integer)SpawnConfigManager.COMMON.spawnLimitationMaxMobsPerServer.get());
    }

    public static void addSpawnRatesForPassiveMobs(String name, Set<String> passiveMobList, int maxPassiveMobsPerPlayer, int maxPassiveMobsPerWorld, int maxPassiveMobsPerServer) {
        if (passiveMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable passive mobs spawn rate control for {} and {} mobs with maxPerPlayer:{}, maxPerWorld:{} and maxPerServer:{}", (Object)name, (Object)passiveMobList.size(), (Object)maxPassiveMobsPerPlayer, (Object)maxPassiveMobsPerWorld, (Object)maxPassiveMobsPerServer);
        SpawnConfigManager.addSpawnRatesForPassiveMobs(passiveMobList, maxPassiveMobsPerPlayer, maxPassiveMobsPerWorld, maxPassiveMobsPerServer);
    }

    public static void addSpawnRatesForNeutralMobs(String name, Set<String> neutralMobList, int maxNeutralMobsPerPlayer, int maxNeutralMobsPerWorld, int maxNeutralMobsPerServer) {
        if (neutralMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable neutral mobs spawn rate control for {} and {} mobs with maxPerPlayer:{}, maxPerWorld:{} and maxPerServer:{}", (Object)name, (Object)neutralMobList.size(), (Object)maxNeutralMobsPerPlayer, (Object)maxNeutralMobsPerWorld, (Object)maxNeutralMobsPerServer);
        SpawnConfigManager.addSpawnRatesForNeutralMobs(neutralMobList, maxNeutralMobsPerPlayer, maxNeutralMobsPerWorld, maxNeutralMobsPerServer);
    }

    public static void addSpawnRatesForHostileMobs(String name, Set<String> hostileMobList, int maxHostileMobsPerPlayer, int maxHostileMobsPerWorld, int maxHostileMobsPerServer) {
        if (hostileMobList.isEmpty()) {
            return;
        }
        log.info("\u2713 Enable hostile mobs spawn rate control for {} and {} mobs with maxPerPlayer:{}, maxPerWorld:{} and maxPerServer:{}", (Object)name, (Object)hostileMobList.size(), (Object)maxHostileMobsPerPlayer, (Object)maxHostileMobsPerWorld, (Object)maxHostileMobsPerServer);
        SpawnConfigManager.addSpawnRatesForHostileMobs(hostileMobList, maxHostileMobsPerPlayer, maxHostileMobsPerWorld, maxHostileMobsPerServer);
    }

    public static void addSpawnRatesForPassiveMobs(Set<String> passiveMobList, int maxPassiveMobsPerPlayer, int maxPassiveMobsPerWorld, int maxPassiveMobsPerServer) {
        for (String entity : passiveMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxPassiveMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxPassiveMobsPerWorld);
            SpawnConfigManager.addSpawnConfigPerServer(entity, maxPassiveMobsPerServer);
        }
    }

    public static void addSpawnRatesForNeutralMobs(Set<String> neutralMobList, int maxNeutralMobsPerPlayer, int maxNeutralMobsPerWorld, int maxNeutralMobsPerServer) {
        for (String entity : neutralMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxNeutralMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxNeutralMobsPerWorld);
            SpawnConfigManager.addSpawnConfigPerServer(entity, maxNeutralMobsPerServer);
        }
    }

    public static void addSpawnRatesForHostileMobs(Set<String> hostileMobList, int maxHostileMobsPerPlayer, int maxHostileMobsPerWorld, int maxHostileMobsPerServer) {
        for (String entity : hostileMobList) {
            SpawnConfigManager.addSpawnConfigPerPlayer(entity, maxHostileMobsPerPlayer);
            SpawnConfigManager.addSpawnConfigPerWorld(entity, maxHostileMobsPerWorld);
            SpawnConfigManager.addSpawnConfigPerServer(entity, maxHostileMobsPerServer);
        }
    }
}

