/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class MinecraftSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private MinecraftSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} Minecraft Spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/MinecraftSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue passiveMobsPerPlayer;
        public final ForgeConfigSpec.IntValue passiveMobsPerWorld;
        public final ForgeConfigSpec.IntValue passiveMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> passiveMobsList;
        public final ForgeConfigSpec.IntValue neutralMobsPerPlayer;
        public final ForgeConfigSpec.IntValue neutralMobsPerWorld;
        public final ForgeConfigSpec.IntValue neutralMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> neutralMobsList;
        public final ForgeConfigSpec.IntValue hostileMobsPerPlayer;
        public final ForgeConfigSpec.IntValue hostileMobsPerWorld;
        public final ForgeConfigSpec.IntValue hostileMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> hostileMobsList;
        public final ForgeConfigSpec.IntValue waterPassiveMobsPerPlayer;
        public final ForgeConfigSpec.IntValue waterPassiveMobsPerWorld;
        public final ForgeConfigSpec.IntValue waterPassiveMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> waterPassiveMobsList;
        public final ForgeConfigSpec.IntValue waterNeutralMobsPerPlayer;
        public final ForgeConfigSpec.IntValue waterNeutralMobsPerWorld;
        public final ForgeConfigSpec.IntValue waterNeutralMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> waterNeutralMobsList;
        public final ForgeConfigSpec.IntValue waterHostileMobsPerPlayer;
        public final ForgeConfigSpec.IntValue waterHostileMobsPerWorld;
        public final ForgeConfigSpec.IntValue waterHostileMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> waterHostileMobsList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Minecraft Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"minecraft");
            this.passiveMobsPerPlayer = builder.comment("e.g. mobs which will not attack you").defineInRange("MaxPassiveMobsPerPlayer", 8, 1, 64);
            this.passiveMobsPerWorld = builder.defineInRange("MaxPassiveMobsPerWorld", 32, 1, 512);
            this.passiveMobsPerServer = builder.defineInRange("MaxPassiveMobsPerServer", 320, 1, 1024);
            this.passiveMobsList = builder.comment("List of passive Mobs to optimize in the format [\"minecraft:bat\", \"minecraft:cat\", ..]").define("PassiveMobsList", new ArrayList<String>(Arrays.asList("minecraft:allay", "minecraft:axolotl", "minecraft:bat", "minecraft:cat", "minecraft:chicken", "minecraft:cow", "minecraft:donkey", "minecraft:fox", "minecraft:frog", "minecraft:horse", "minecraft:mooshroom", "minecraft:mule", "minecraft:ocelot", "minecraft:parrot", "minecraft:pig", "minecraft:rabbit", "minecraft:sheep", "minecraft:skeleton_horse", "minecraft:snow_golem", "minecraft:turtle")));
            this.neutralMobsPerPlayer = builder.comment("e.g. mobs which will attack under certain conditions ...").defineInRange("MaxNeutralMobsPerPlayer", 8, 1, 64);
            this.neutralMobsPerWorld = builder.defineInRange("MaxNeutralMobsPerWorld", 32, 1, 512);
            this.neutralMobsPerServer = builder.defineInRange("MaxNeutralMobsPerServer", 320, 1, 1024);
            this.neutralMobsList = builder.comment("List of neutral Mobs to optimize in the format [\"minecraft:bee\", \"minecraft:wolf\", ..]").define("NeutralMobsList", new ArrayList<String>(Arrays.asList("minecraft:bee", "minecraft:cave_spider", "minecraft:enderman", "minecraft:goat", "minecraft:iron_golem", "minecraft:llama", "minecraft:panda", "minecraft:polar_bear", "minecraft:spider", "minecraft:trader_llama", "minecraft:wandering_trader", "minecraft:wolf", "minecraft:zombie_horse")));
            this.hostileMobsPerPlayer = builder.comment("e.g. mobs which will always attack yon ...").defineInRange("MaxHostileMobsPerPlayer", 8, 1, 64);
            this.hostileMobsPerWorld = builder.defineInRange("MaxHostileMobsPerWorld", 32, 1, 512);
            this.hostileMobsPerServer = builder.defineInRange("MaxHostileMobsPerServer", 320, 1, 1024);
            this.hostileMobsList = builder.comment("List of hostile Mobs to optimize in the format [\"minecraft:blaze\", \"minecraft:cave_spider\", ..]").define("HostileMobsList", new ArrayList<String>(Arrays.asList("minecraft:chicken_jockey", "minecraft:creeper", "minecraft:ender_dragon", "minecraft:endermite", "minecraft:evoker", "minecraft:giant", "minecraft:husk", "minecraft:illusioner", "minecraft:phantom", "minecraft:pillager", "minecraft:ravager", "minecraft:ravager_jockey", "minecraft:shulker", "minecraft:silverfish", "minecraft:skeleton", "minecraft:skeleton_horseman", "minecraft:slime", "minecraft:stray", "minecraft:vex", "minecraft:vindicator", "minecraft:warden", "minecraft:witch", "minecraft:wither", "minecraft:zoglin", "minecraft:zombie", "minecraft:zombie_villager")));
            this.waterPassiveMobsPerPlayer = builder.comment("e.g. mostly fish").defineInRange("MaxWaterPassiveMobsPerPlayer", 8, 1, 64);
            this.waterPassiveMobsPerWorld = builder.defineInRange("MaxWaterPassiveMobsPerWorld", 32, 1, 512);
            this.waterPassiveMobsPerServer = builder.defineInRange("MaxWaterPassiveMobsPerServer", 320, 1, 1024);
            this.waterPassiveMobsList = builder.comment("List of passive water Mobs to optimize").define("WaterPassiveMobsList", new ArrayList<String>(Arrays.asList("minecraft:axolotl", "minecraft:cod", "minecraft:pufferfish", "minecraft:salmon", "minecraft:tropical_fish")));
            this.waterNeutralMobsPerPlayer = builder.comment("e.g. squid, dolphin, ...").defineInRange("MaxWaterNeutralMobsPerPlayer", 6, 1, 64);
            this.waterNeutralMobsPerWorld = builder.defineInRange("MaxWaterNeutralMobsPerWorld", 24, 1, 512);
            this.waterNeutralMobsPerServer = builder.defineInRange("MaxWaterNeutralMobsPerServer", 320, 1, 1024);
            this.waterNeutralMobsList = builder.comment("List of neutral water Mobs to optimize").define("WaterNeutralMobsList", new ArrayList<String>(Arrays.asList("minecraft:dolphin", "minecraft:squid")));
            this.waterHostileMobsPerPlayer = builder.comment("e.g. drowned, guardian...").defineInRange("MaxWaterHostileMobsPerPlayer", 16, 1, 64);
            this.waterHostileMobsPerWorld = builder.defineInRange("MaxWaterHostileMobsPerWorld", 64, 1, 512);
            this.waterHostileMobsPerServer = builder.defineInRange("MaxWaterHostileMobsPerServer", 320, 1, 1024);
            this.waterHostileMobsList = builder.comment("List of hostile water Mobs to optimize").define("WaterHostileMobsList", new ArrayList<String>(Arrays.asList("minecraft:drowned", "minecraft:elder_guardian", "minecraft:guardian")));
            builder.pop();
        }
    }
}

