/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ExoticBirdsSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    private static final Logger log;

    private ExoticBirdsSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} Exotic Birds spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/ExoticBirdsSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue passiveMobsPerPlayer;
        public final ForgeConfigSpec.IntValue passiveMobsPerWorld;
        public final ForgeConfigSpec.IntValue passiveMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> passiveMobsList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Exotic Birds Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"exoticbirds");
            this.passiveMobsPerPlayer = builder.defineInRange("MaxPassiveMobsPerPlayer", 4, 1, 64);
            this.passiveMobsPerWorld = builder.defineInRange("MaxPassiveMobsPerWorld", 16, 1, 512);
            this.passiveMobsPerServer = builder.defineInRange("MaxPassiveMobsPerServer", 64, 1, 1024);
            this.passiveMobsList = builder.comment("List of passive Mobs to optimize in the format [\"minecraft:bat\", \"minecraft:cat\", ..]").define("PassiveMobsList", new ArrayList<String>(Arrays.asList("exoticbirds:peafowl", "exoticbirds:hummingbird", "exoticbirds:woodpecker", "exoticbirds:kingfisher", "exoticbirds:roadrunner", "exoticbirds:toucan", "exoticbirds:swan", "exoticbirds:macaw", "exoticbirds:cassowary", "exoticbirds:magpie", "exoticbirds:flamingo", "exoticbirds:kiwi", "exoticbirds:owl", "exoticbirds:pelican", "exoticbirds:lyrebird", "exoticbirds:ostrich", "exoticbirds:gouldianfinch", "exoticbirds:gull", "exoticbirds:pigeon", "exoticbirds:duck", "exoticbirds:penguin", "exoticbirds:heron", "exoticbirds:booby", "exoticbirds:bluejay", "exoticbirds:cardinal", "exoticbirds:robin", "exoticbirds:crane", "exoticbirds:kookaburra", "exoticbirds:budgerigar", "exoticbirds:cockatoo", "exoticbirds:fire_phoenix", "exoticbirds:cloud_phoenix", "exoticbirds:water_phoenix", "exoticbirds:nether_phoenix", "exoticbirds:skeleton_phoenix", "exoticbirds:snowy_phoenix", "exoticbirds:desert_phoenix", "exoticbirds:ender_phoenix", "exoticbirds:twilight_phoenix")));
            builder.pop();
        }
    }
}

