/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.adaptiveperformancetweaksspawn.config.spawn;

import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class AlexsMobsSpawnConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Config COMMON;
    protected static final Logger log;

    private AlexsMobsSpawnConfig() {
    }

    static {
        log = LogManager.getLogger((String)"APTweaks(Spawn)");
        com.electronwill.nightconfig.core.Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Config)specPair.getLeft();
        log.info("Registering {} {} spawn config ...", (Object)"Adaptive Performance Tweaks: Spawn", (Object)"Alex's Mobs");
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("adaptive_performance_tweaks"), new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the directory:", (Throwable)exception);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec, "adaptive_performance_tweaks//spawn/AlexsMobsSpawn.toml");
    }

    public static class Config {
        public final ForgeConfigSpec.BooleanValue enabled;
        public final ForgeConfigSpec.ConfigValue<String> id;
        public final ForgeConfigSpec.IntValue passiveMobsPerPlayer;
        public final ForgeConfigSpec.IntValue passiveMobsPerWorld;
        public final ForgeConfigSpec.IntValue passiveMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> passiveMobsList;
        public final ForgeConfigSpec.IntValue neutralMobsPerPlayer;
        public final ForgeConfigSpec.IntValue neutralMobsPerWorld;
        public final ForgeConfigSpec.IntValue neutralMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> neutralMobsList;
        public final ForgeConfigSpec.IntValue hostileMobsPerPlayer;
        public final ForgeConfigSpec.IntValue hostileMobsPerWorld;
        public final ForgeConfigSpec.IntValue hostileMobsPerServer;
        public final ForgeConfigSpec.ConfigValue<List<String>> hostileMobsList;

        Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Adaptive Performance Tweaks: Spawn");
            builder.push("Alexs Mobs Spawn Config");
            this.enabled = builder.define("Enabled", true);
            this.id = builder.define("Id", (Object)"alexsmobs");
            this.passiveMobsPerPlayer = builder.defineInRange("MaxPassiveMobsPerPlayer", 4, 1, 64);
            this.passiveMobsPerWorld = builder.defineInRange("MaxPassiveMobsPerWorld", 16, 1, 512);
            this.passiveMobsPerServer = builder.defineInRange("MaxPassiveMobsPerServer", 320, 1, 1024);
            this.passiveMobsList = builder.comment("List of passive Mobs to optimize in the format [\"minecraft:bat\", \"minecraft:cat\", ..]").define("PassiveMobsList", new ArrayList<String>(Arrays.asList("alexsmobs:blobfish", "alexsmobs:endergrade", "alexsmobs:fly", "alexsmobs:gazelle", "alexsmobs:hummingbird", "alexsmobs:mungus", "alexsmobs:seal", "alexsmobs:spectre", "alexsmobs:stradpole", "alexsmobs:sunbird")));
            this.neutralMobsPerPlayer = builder.defineInRange("MaxNeutralMobsPerPlayer", 4, 1, 64);
            this.neutralMobsPerWorld = builder.defineInRange("MaxNeutralMobsPerWorld", 16, 1, 512);
            this.neutralMobsPerServer = builder.defineInRange("MaxNeutralMobsPerServer", 320, 1, 1024);
            this.neutralMobsList = builder.comment("List of neutral Mobs to optimize in the format [\"minecraft:bee\", \"minecraft:wolf\", ..]").define("NeutralMobsList", new ArrayList<String>(Arrays.asList("alexsmobs:cachalot_whale", "alexsmobs:capuchin_monkey", "alexsmobs:cockroach", "alexsmobs:crow", "alexsmobs:elephant", "alexsmobs:emu", "alexsmobs:gorilla", "alexsmobs:kangaroo", "alexsmobs:lobster", "alexsmobs:mantis_shrimp", "alexsmobs:moose", "alexsmobs:orca", "alexsmobs:platypus", "alexsmobs:raccoon", "alexsmobs:roadrunner", "alexsmobs:shoebill", "alexsmobs:snow_leopard", "alexsmobs:tasmanian_devil", "alexsmobs:warped_toad")));
            this.hostileMobsPerPlayer = builder.defineInRange("MaxHostileMobsPerPlayer", 4, 1, 64);
            this.hostileMobsPerWorld = builder.defineInRange("MaxHostileMobsPerWorld", 16, 1, 512);
            this.hostileMobsPerServer = builder.defineInRange("MaxHostileMobsPerServer", 320, 1, 1024);
            this.hostileMobsList = builder.comment("List of hostile Mobs to optimize in the format [\"minecraft:blaze\", \"minecraft:cave_spider\", ..]").define("HostileMobsList", new ArrayList<String>(Arrays.asList("alexsmobs:alligator_snapping_turtle", "alexsmobs:bone_serpent", "alexsmobs:centipede_head", "alexsmobs:crimson_mosquito", "alexsmobs:crocodile", "alexsmobs:dropbear", "alexsmobs:enderiophage", "alexsmobs:grizzly_bear", "alexsmobs:guster", "alexsmobs:hammerhead_shark", "alexsmobs:komodo_dragon", "alexsmobs:leafcutter_ant", "alexsmobs:mimicube", "alexsmobs:rattlesnake", "alexsmobs:soul_vulture", "alexsmobs:straddler", "alexsmobs:warped_mosco")));
            builder.pop();
        }
    }
}

