/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client;

import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.gui.modular.sprite.ModAtlasHolder;
import com.brandon3055.brandonscore.BCConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;

public class BCGuiTextures {
    private static final ModAtlasHolder ATLAS_HOLDER = new ModAtlasHolder("brandonscore", "textures/atlas/gui.png", "gui");
    private static final Map<String, Material> MATERIAL_CACHE = new HashMap<String, Material>();

    public static ModAtlasHolder getAtlasHolder() {
        return ATLAS_HOLDER;
    }

    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)BCGuiTextures.getAtlasHolder());
    }

    public static Material get(String texture) {
        return MATERIAL_CACHE.computeIfAbsent("brandonscore:" + texture, e -> BCGuiTextures.getUncached(texture));
    }

    public static Supplier<Material> getter(Supplier<String> texture) {
        return () -> BCGuiTextures.get((String)texture.get());
    }

    public static Supplier<Material> getter(String texture) {
        return () -> BCGuiTextures.get(texture);
    }

    public static Material getUncached(String texture) {
        return new Material(ATLAS_HOLDER.atlasLocation(), new ResourceLocation("brandonscore", "gui/" + texture), arg_0 -> ((ModAtlasHolder)ATLAS_HOLDER).getSprite(arg_0));
    }

    public static Material getThemed(String location) {
        return BCGuiTextures.get((BCConfig.darkMode ? "dark/" : "light/") + location);
    }

    public static Supplier<Material> themedGetter(String location) {
        return () -> BCGuiTextures.get((BCConfig.darkMode ? "dark/" : "light/") + location);
    }
}

