/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.Furnace;
import xiroc.dungeoncrawl.dungeon.block.Plants;
import xiroc.dungeoncrawl.dungeon.block.Spawner;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public interface IBlockPlacementHandler {
    public static final IBlockPlacementHandler SPAWNER = new Spawner();
    public static final IBlockPlacementHandler DEFAULT = (world, state, pos, rand, theme, secondaryTheme, lootLevel) -> {
        if (((Boolean)Config.TICK_FALLING_BLOCKS.get()).booleanValue() && state.m_60734_() instanceof FallingBlock) {
            world.m_186460_(pos, state.m_60734_(), 1);
        }
        world.m_7731_(pos, state, 2);
    };
    public static final ImmutableMap<Block, IBlockPlacementHandler> PLACEMENT_HANDLERS = new ImmutableMap.Builder().put((Object)Blocks.f_50094_, (Object)new Furnace()).put((Object)Blocks.f_50619_, (Object)new Furnace.Smoker()).put((Object)Blocks.f_50085_, (Object)SPAWNER).put((Object)Blocks.f_50093_, (Object)new Plants.Farmland()).put((Object)Blocks.f_50276_, (Object)new Plants.FlowerPot()).put((Object)Blocks.f_50599_, (Object)new Plants.Podzol()).build();

    public void place(LevelAccessor var1, BlockState var2, BlockPos var3, RandomSource var4, Theme var5, SecondaryTheme var6, int var7);

    public static IBlockPlacementHandler getHandler(Block block) {
        return (IBlockPlacementHandler)PLACEMENT_HANDLERS.getOrDefault((Object)block, (Object)DEFAULT);
    }
}

