/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.theme;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Blocks;
import org.jline.utils.InputStreamReader;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.block.provider.BlockStateProvider;
import xiroc.dungeoncrawl.dungeon.block.provider.SingleBlock;
import xiroc.dungeoncrawl.dungeon.decoration.DungeonDecoration;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.theme.JsonTheming;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.util.IRandom;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class Theme {
    public static final Theme BUILTIN_DEFAULT_THEME = new Theme(new SingleBlock(Blocks.f_50222_.m_49966_()), new SingleBlock(Blocks.f_50222_.m_49966_()), new SingleBlock(Blocks.f_50652_.m_49966_()), new SingleBlock(Blocks.f_49994_.m_49966_()), new SingleBlock(Blocks.f_50194_.m_49966_()), new SingleBlock(Blocks.f_50157_.m_49966_()), new SingleBlock(Blocks.f_50652_.m_49966_()), new SingleBlock(Blocks.f_50274_.m_49966_()), new SingleBlock(Blocks.f_50409_.m_49966_()), new SingleBlock(Blocks.f_50411_.m_49966_()), new SingleBlock(Blocks.f_50183_.m_49966_()), new SingleBlock(Blocks.f_49990_.m_49966_()));
    public static final SecondaryTheme BUILTIN_DEFAULT_SECONDARY_THEME = new SecondaryTheme(new SingleBlock(Blocks.f_49999_.m_49966_()), new SingleBlock(Blocks.f_50216_.m_49966_()), new SingleBlock(Blocks.f_50154_.m_49966_()), new SingleBlock(Blocks.f_50705_.m_49966_()), new SingleBlock(Blocks.f_50086_.m_49966_()), new SingleBlock(Blocks.f_50398_.m_49966_()), new SingleBlock(Blocks.f_50132_.m_49966_()), new SingleBlock(Blocks.f_50192_.m_49966_()), new SingleBlock(Blocks.f_50251_.m_49966_()), new SingleBlock(Blocks.f_50167_.m_49966_()));
    protected static final Hashtable<String, IRandom<Theme>> BIOME_TO_THEME = new Hashtable();
    protected static final Hashtable<String, IRandom<SecondaryTheme>> BIOME_TO_SECONDARY_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, Theme> KEY_TO_THEME = new Hashtable();
    public static final Hashtable<ResourceLocation, SecondaryTheme> KEY_TO_SECONDARY_THEME = new Hashtable();
    private static WeightedRandom<Theme> DEFAULT_TOP_THEME = null;
    private static WeightedRandom<SecondaryTheme> DEFAULT_SECONDARY_TOP_THEME = null;
    private static IRandom<Theme> CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> LOWER_CATACOMBS_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<Theme> HELL_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> LOWER_CATACOMBS_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    private static IRandom<SecondaryTheme> HELL_SECONDARY_THEME = rand -> {
        throw new IllegalStateException();
    };
    public static final Hashtable<Integer, Theme> ID_TO_THEME = new Hashtable();
    public static final Hashtable<Integer, SecondaryTheme> ID_TO_SECONDARY_THEME = new Hashtable();
    private static final ResourceLocation PRIMARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/default");
    private static final ResourceLocation SECONDARY_THEME_FALLBACK = DungeonCrawl.locate("vanilla/oak");
    public static final ResourceLocation PRIMARY_HELL_MOSSY = DungeonCrawl.locate("vanilla/hell/mossy");
    private static final String PRIMARY_THEME_DIRECTORY = "theming/primary_themes";
    private static final String SECONDARY_THEME_DIRECTORY = "theming/secondary_themes";
    private static final String PRIMARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/primary";
    private static final String SECONDARY_THEME_MAPPINGS_DIRECTORY = "theming/mappings/secondary";
    private static final String UPPER_CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/upper_catacombs";
    private static final String CATACOMBS_THEMES_DIRECTORY = "theming/lower_layers/catacombs";
    private static final String HELL_THEMES_DIRECTORY = "theming/lower_layers/hell";
    private static ImmutableSet<ResourceLocation> THEME_KEYS;
    private static ImmutableSet<ResourceLocation> SECONDARY_THEME_KEYS;
    public final BlockStateProvider pillar;
    public final BlockStateProvider solid;
    public final BlockStateProvider generic;
    public final BlockStateProvider floor;
    public final BlockStateProvider solidStairs;
    public final BlockStateProvider stairs;
    public final BlockStateProvider material;
    public final BlockStateProvider wall;
    public final BlockStateProvider slab;
    public final BlockStateProvider solidSlab;
    public final BlockStateProvider fencing;
    public final BlockStateProvider fluid;
    public IRandom<SecondaryTheme> secondaryTheme;
    protected ResourceLocation key;
    @Nullable
    private DungeonDecoration[] decorations;
    @Nullable
    protected Integer id;

    public Theme(BlockStateProvider pillar, BlockStateProvider solid, BlockStateProvider generic, BlockStateProvider floor, BlockStateProvider solidStairs, BlockStateProvider stairs, BlockStateProvider material, BlockStateProvider wall, BlockStateProvider slab, BlockStateProvider solidSlab, BlockStateProvider fencing, BlockStateProvider fluid) {
        this.solid = solid;
        this.material = material;
        this.generic = generic;
        this.pillar = pillar;
        this.floor = floor;
        this.stairs = stairs;
        this.solidStairs = solidStairs;
        this.slab = slab;
        this.solidSlab = solidSlab;
        this.wall = wall;
        this.fencing = fencing;
        this.fluid = fluid;
    }

    public void setDecorations(@Nullable DungeonDecoration[] decorations) {
        this.decorations = decorations;
    }

    public boolean hasDecorations() {
        return this.decorations != null;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public DungeonDecoration[] getDecorations() {
        return this.decorations;
    }

    public BlockStateProvider getPillar() {
        return this.pillar;
    }

    public BlockStateProvider getSolid() {
        return this.solid;
    }

    public BlockStateProvider getGeneric() {
        return this.generic;
    }

    public BlockStateProvider getFencing() {
        return this.fencing;
    }

    public BlockStateProvider getFloor() {
        return this.floor;
    }

    public BlockStateProvider getFluid() {
        return this.fluid;
    }

    public BlockStateProvider getSolidStairs() {
        return this.solidStairs;
    }

    public BlockStateProvider getStairs() {
        return this.stairs;
    }

    public BlockStateProvider getMaterial() {
        return this.material;
    }

    public BlockStateProvider getWall() {
        return this.wall;
    }

    public BlockStateProvider getSlab() {
        return this.slab;
    }

    public BlockStateProvider getSolidSlab() {
        return this.solidSlab;
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        if (this.decorations != null) {
            JsonArray decorations = new JsonArray();
            for (DungeonDecoration decoration : this.decorations) {
                decorations.add((JsonElement)decoration.serialize());
            }
            object.add("decorations", (JsonElement)decorations);
        }
        JsonObject theme = new JsonObject();
        theme.add("pillar", (JsonElement)this.pillar.serialize());
        theme.add("solid", (JsonElement)this.solid.serialize());
        theme.add("generic", (JsonElement)this.generic.serialize());
        theme.add("fencing", (JsonElement)this.fencing.serialize());
        theme.add("floor", (JsonElement)this.floor.serialize());
        theme.add("fluid", (JsonElement)this.fluid.serialize());
        theme.add("solid_stairs", (JsonElement)this.solidStairs.serialize());
        theme.add("stairs", (JsonElement)this.stairs.serialize());
        theme.add("material", (JsonElement)this.material.serialize());
        theme.add("wall", (JsonElement)this.wall.serialize());
        theme.add("slab", (JsonElement)this.slab.serialize());
        theme.add("solid_slab", (JsonElement)this.solidSlab.serialize());
        object.add("theme", (JsonElement)theme);
        return object;
    }

    public static void loadJson(ResourceManager resourceManager) {
        ID_TO_THEME.clear();
        ID_TO_SECONDARY_THEME.clear();
        KEY_TO_THEME.clear();
        KEY_TO_SECONDARY_THEME.clear();
        BIOME_TO_THEME.clear();
        BIOME_TO_SECONDARY_THEME.clear();
        ImmutableSet.Builder themeKeySetBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder secondaryThemeKeySetBuilder = new ImmutableSet.Builder();
        resourceManager.m_214159_(DungeonCrawl.locate(SECONDARY_THEME_DIRECTORY).m_135815_(), s -> s.m_135815_().endsWith(".json")).forEach((file, resource) -> {
            DungeonCrawl.LOGGER.debug("Loading {}", file);
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                ResourceLocation key = DungeonCrawl.key(file, SECONDARY_THEME_DIRECTORY, ".json");
                JsonObject json = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                if (JSONUtils.areRequirementsMet(json)) {
                    SecondaryTheme theme = JsonTheming.deserializeSecondaryTheme(json, file);
                    theme.key = key;
                    secondaryThemeKeySetBuilder.add((Object)key);
                    KEY_TO_SECONDARY_THEME.put(key, theme);
                }
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        });
        resourceManager.m_214159_(DungeonCrawl.locate(PRIMARY_THEME_DIRECTORY).m_135815_(), s -> s.m_135815_().endsWith(".json")).forEach((file, resource) -> {
            DungeonCrawl.LOGGER.debug("Loading {}", file);
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                ResourceLocation key = DungeonCrawl.key(file, PRIMARY_THEME_DIRECTORY, ".json");
                JsonObject json = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                if (JSONUtils.areRequirementsMet(json)) {
                    Theme theme = JsonTheming.deserializeTheme(json, file);
                    theme.key = key;
                    themeKeySetBuilder.add((Object)key);
                    KEY_TO_THEME.put(key, theme);
                }
            }
            catch (Exception e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", (Object)resource.toString());
                e.printStackTrace();
            }
        });
        Hashtable<String, WeightedRandom.Builder> themeMappingBuilders = new Hashtable<String, WeightedRandom.Builder>();
        Hashtable<String, WeightedRandom.Builder> secondaryThemeMappingBuilders = new Hashtable<String, WeightedRandom.Builder>();
        WeightedRandom.Builder primaryDefaultBuilder = new WeightedRandom.Builder();
        WeightedRandom.Builder secondaryDefaultBuilder = new WeightedRandom.Builder();
        resourceManager.m_214159_(PRIMARY_THEME_MAPPINGS_DIRECTORY, s -> s.m_135815_().endsWith(".json")).forEach((file, resource) -> {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                JsonTheming.deserializeThemeMapping(JsonParser.parseReader((JsonReader)reader).getAsJsonObject(), themeMappingBuilders, primaryDefaultBuilder, file);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", resource);
                e.printStackTrace();
            }
        });
        resourceManager.m_214159_(SECONDARY_THEME_MAPPINGS_DIRECTORY, s -> s.m_135815_().endsWith(".json")).forEach((file, resource) -> {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                JsonTheming.deserializeSecondaryThemeMapping(JsonParser.parseReader((JsonReader)reader).getAsJsonObject(), secondaryThemeMappingBuilders, secondaryDefaultBuilder, file);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", resource);
                e.printStackTrace();
            }
        });
        themeMappingBuilders.forEach((biome, builder) -> BIOME_TO_THEME.put((String)biome, builder.build()));
        secondaryThemeMappingBuilders.forEach((biome, builder) -> BIOME_TO_SECONDARY_THEME.put((String)biome, builder.build()));
        DEFAULT_TOP_THEME = primaryDefaultBuilder.build();
        DEFAULT_SECONDARY_TOP_THEME = secondaryDefaultBuilder.build();
        if (DEFAULT_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default primary themes are specified in the mappings.");
        }
        if (DEFAULT_SECONDARY_TOP_THEME.isEmpty()) {
            throw new DatapackLoadException("No default secondary themes are specified in the mappings.");
        }
        THEME_KEYS = themeKeySetBuilder.build();
        SECONDARY_THEME_KEYS = secondaryThemeKeySetBuilder.build();
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> catacombs = Theme.loadRandomThemeFiles(UPPER_CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> lowerCatacombs = Theme.loadRandomThemeFiles(CATACOMBS_THEMES_DIRECTORY, resourceManager);
        Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> hell = Theme.loadRandomThemeFiles(HELL_THEMES_DIRECTORY, resourceManager);
        CATACOMBS_THEME = (IRandom)catacombs.m_14418_();
        CATACOMBS_SECONDARY_THEME = (IRandom)catacombs.m_14419_();
        LOWER_CATACOMBS_THEME = (IRandom)lowerCatacombs.m_14418_();
        LOWER_CATACOMBS_SECONDARY_THEME = (IRandom)lowerCatacombs.m_14419_();
        HELL_THEME = (IRandom)hell.m_14418_();
        HELL_SECONDARY_THEME = (IRandom)hell.m_14419_();
    }

    private static Tuple<WeightedRandom<Theme>, WeightedRandom<SecondaryTheme>> loadRandomThemeFiles(String directory, ResourceManager resourceManager) {
        WeightedRandom.Builder primary = new WeightedRandom.Builder();
        WeightedRandom.Builder secondary = new WeightedRandom.Builder();
        resourceManager.m_214159_(directory, s -> s.m_135815_().endsWith(".json")).forEach((file, resource) -> {
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                JsonTheming.deserializeRandomThemeFile(JsonParser.parseReader((JsonReader)reader).getAsJsonObject(), primary, secondary, file);
            }
            catch (IOException e) {
                DungeonCrawl.LOGGER.error("Failed to load {}", resource);
                e.printStackTrace();
            }
        });
        if (primary.entries.isEmpty()) {
            throw new DatapackLoadException("No primary themes were present after loading " + directory);
        }
        if (secondary.entries.isEmpty()) {
            throw new DatapackLoadException("No secondary themes were present after loading " + directory);
        }
        return new Tuple(primary.build(), secondary.build());
    }

    public static Theme getBuiltinDefaultTheme() {
        return KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME);
    }

    public static SecondaryTheme getBuiltinDefaultSecondaryTheme() {
        return KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static Theme randomTheme(String biome, RandomSource rand) {
        return (Theme)((IRandom)BIOME_TO_THEME.getOrDefault(biome, DEFAULT_TOP_THEME)).roll(rand);
    }

    public static SecondaryTheme randomSecondaryTheme(String biome, RandomSource rand) {
        return (SecondaryTheme)((IRandom)BIOME_TO_SECONDARY_THEME.getOrDefault(biome, DEFAULT_SECONDARY_TOP_THEME)).roll(rand);
    }

    public static Theme randomCatacombsTheme(RandomSource rand) {
        return CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomCatacombsSecondaryTheme(RandomSource rand) {
        return CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomLowerCatacombsTheme(RandomSource rand) {
        return LOWER_CATACOMBS_THEME.roll(rand);
    }

    public static SecondaryTheme randomLowerCatacombsSecondaryTheme(RandomSource rand) {
        return LOWER_CATACOMBS_SECONDARY_THEME.roll(rand);
    }

    public static Theme randomHellTheme(RandomSource rand) {
        return HELL_THEME.roll(rand);
    }

    public static SecondaryTheme randomHellSecondaryTheme(RandomSource rand) {
        return HELL_SECONDARY_THEME.roll(rand);
    }

    public static Theme getTheme(ResourceLocation key) {
        return KEY_TO_THEME.getOrDefault(key, KEY_TO_THEME.getOrDefault(PRIMARY_THEME_FALLBACK, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSecondaryTheme(ResourceLocation key) {
        return KEY_TO_SECONDARY_THEME.getOrDefault(key, KEY_TO_SECONDARY_THEME.getOrDefault(SECONDARY_THEME_FALLBACK, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static Theme getThemeByID(int theme) {
        return ID_TO_THEME.getOrDefault(theme, ID_TO_THEME.getOrDefault(0, BUILTIN_DEFAULT_THEME));
    }

    public static SecondaryTheme getSecondaryThemeByID(int id) {
        return ID_TO_SECONDARY_THEME.getOrDefault(id, ID_TO_SECONDARY_THEME.getOrDefault(0, BUILTIN_DEFAULT_SECONDARY_THEME));
    }

    public static ImmutableSet<ResourceLocation> getThemeKeys() {
        return THEME_KEYS;
    }

    public static ImmutableSet<ResourceLocation> getSecondaryThemeKeys() {
        return SECONDARY_THEME_KEYS;
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        Theme.BUILTIN_DEFAULT_THEME.key = new ResourceLocation("builtin:default");
        Theme.BUILTIN_DEFAULT_SECONDARY_THEME.key = new ResourceLocation("builtin:default");
        KEY_TO_THEME.put(BUILTIN_DEFAULT_THEME.getKey(), BUILTIN_DEFAULT_THEME);
        KEY_TO_SECONDARY_THEME.put(BUILTIN_DEFAULT_SECONDARY_THEME.getKey(), BUILTIN_DEFAULT_SECONDARY_THEME);
    }

    public static class Builder {
        private BlockStateProvider pillar = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider solid = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider generic = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider floor = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider solidStairs = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider stairs = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider material = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider wall = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider slab = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider solidSlab = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider fencing = new SingleBlock(Blocks.f_50016_.m_49966_());
        private BlockStateProvider fluid = new SingleBlock(Blocks.f_50016_.m_49966_());
        private Integer id;
        private List<DungeonDecoration> decorations = new ArrayList<DungeonDecoration>();
        private IRandom<SecondaryTheme> secondaryTheme;

        public Builder legacyId(int id) {
            this.id = id;
            return this;
        }

        public Builder addDecoration(DungeonDecoration decoration) {
            this.decorations.add(decoration);
            return this;
        }

        public Builder secondaryTheme(IRandom<SecondaryTheme> secondaryTheme) {
            this.secondaryTheme = secondaryTheme;
            return this;
        }

        public Builder pillar(BlockStateProvider pillar) {
            this.pillar = pillar;
            return this;
        }

        public Builder solid(BlockStateProvider solid) {
            this.solid = solid;
            return this;
        }

        public Builder generic(BlockStateProvider generic) {
            this.generic = generic;
            return this;
        }

        public Builder floor(BlockStateProvider floor) {
            this.floor = floor;
            return this;
        }

        public Builder solidStairs(BlockStateProvider solidStairs) {
            this.solidStairs = solidStairs;
            return this;
        }

        public Builder stairs(BlockStateProvider stairs) {
            this.stairs = stairs;
            return this;
        }

        public Builder material(BlockStateProvider material) {
            this.material = material;
            return this;
        }

        public Builder wall(BlockStateProvider wall) {
            this.wall = wall;
            return this;
        }

        public Builder slab(BlockStateProvider slab) {
            this.slab = slab;
            return this;
        }

        public Builder solidSlab(BlockStateProvider solidSlab) {
            this.solidSlab = solidSlab;
            return this;
        }

        public Builder fencing(BlockStateProvider fencing) {
            this.fencing = fencing;
            return this;
        }

        public Builder fluid(BlockStateProvider fluid) {
            this.fluid = fluid;
            return this;
        }

        public Theme build() {
            Theme theme = new Theme(this.pillar, this.solid, this.generic, this.floor, this.solidStairs, this.stairs, this.material, this.wall, this.slab, this.solidSlab, this.fencing, this.fluid);
            if (this.id != null) {
                theme.id = this.id;
                ID_TO_THEME.put(this.id, theme);
            }
            if (!this.decorations.isEmpty()) {
                theme.decorations = this.decorations.toArray(new DungeonDecoration[0]);
            }
            return theme;
        }
    }
}

