/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.registry.CyclicRecipeType;
import com.lothrazar.library.recipe.ingredient.EnergyIngredient;
import com.lothrazar.library.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.library.util.RecipeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class RecipeSolidifier
implements Recipe<TileSolidifier> {
    private final ResourceLocation id;
    public ItemStack result = ItemStack.f_41583_;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final EnergyIngredient energy;
    public final FluidTagIngredient fluidIngredient;

    public RecipeSolidifier(ResourceLocation id, NonNullList<Ingredient> inList, FluidTagIngredient fluid, ItemStack result, EnergyIngredient energy) {
        this.id = id;
        this.energy = energy;
        this.ingredients = inList;
        if (this.ingredients.size() == 2) {
            this.ingredients.add((Object)Ingredient.f_43901_);
        } else if (this.ingredients.size() == 1) {
            this.ingredients.add((Object)Ingredient.f_43901_);
            this.ingredients.add((Object)Ingredient.f_43901_);
        }
        if (this.ingredients.size() != 3) {
            throw new IllegalArgumentException("Solidifier recipe must have at most three ingredients");
        }
        this.fluidIngredient = fluid;
        this.result = result;
    }

    public FluidStack getRecipeFluid() {
        return this.fluidIngredient.getFluidStack();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack assemble(TileSolidifier inv, RegistryAccess ra) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public EnergyIngredient getEnergy() {
        return this.energy;
    }

    public boolean matches(TileSolidifier inv, Level worldIn) {
        try {
            TileSolidifier tile = inv;
            return this.matchItems(tile) && RecipeUtil.matchFluid((FluidStack)tile.getFluid(), (FluidTagIngredient)this.fluidIngredient);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private int findMatchingSlot(TileSolidifier tile, Ingredient shapeless, List<Integer> skip) {
        for (int i = 0; i < 3; ++i) {
            if (skip.contains(i) || !shapeless.test(tile.getStackInputSlot(i))) continue;
            return i;
        }
        return -1;
    }

    public Ingredient at(int slot) {
        return (Ingredient)this.ingredients.get(slot);
    }

    private boolean matchItems(TileSolidifier tile) {
        Ingredient top = this.at(0);
        Ingredient middle = this.at(1);
        Ingredient bottom = this.at(2);
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        matchingSlots.add(this.findMatchingSlot(tile, top, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, middle, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, bottom, matchingSlots));
        if (matchingSlots.contains(-1)) {
            return false;
        }
        return matchingSlots.contains(0) && matchingSlots.contains(1) && matchingSlots.contains(2);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = this.at(slot);
        return ing.m_43908_();
    }

    public ItemStack m_8043_(RegistryAccess ra) {
        return this.result.m_41777_();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)CyclicRecipeType.SOLID.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CyclicRecipeType.SOLID_S.get();
    }

    public static class SerializeSolidifier
    implements RecipeSerializer<RecipeSolidifier> {
        public RecipeSolidifier fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeSolidifier r = null;
            try {
                NonNullList list = RecipeUtil.getIngredientsArray((JsonObject)json);
                ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                FluidTagIngredient fs = RecipeUtil.parseFluid((JsonObject)json, (String)"mix");
                r = new RecipeSolidifier(recipeId, (NonNullList<Ingredient>)list, fs, resultStack, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeSolidifier fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
            NonNullList ins = NonNullList.m_122779_();
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            FluidTagIngredient fsi = FluidTagIngredient.readFromPacket((FriendlyByteBuf)buf);
            RecipeSolidifier r = new RecipeSolidifier(recipeId, (NonNullList<Ingredient>)ins, fsi, buf.m_130267_(), new EnergyIngredient(buf.readInt(), buf.readInt()));
            return r;
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeSolidifier recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            Ingredient two = (Ingredient)recipe.ingredients.get(2);
            zero.m_43923_(buf);
            one.m_43923_(buf);
            two.m_43923_(buf);
            recipe.fluidIngredient.writeToPacket(buf);
            buf.m_130055_(recipe.result);
            buf.writeInt(recipe.energy.getRfPertick());
            buf.writeInt(recipe.energy.getTicks());
        }
    }
}

