/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.laser;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.laser.ContainerLaser;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.data.OffsetEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileLaser
extends TileBlockEntityCyclic
implements MenuProvider {
    protected OffsetEnum xOffset = OffsetEnum.CENTER;
    protected OffsetEnum yOffset = OffsetEnum.CENTER;
    protected OffsetEnum zOffset = OffsetEnum.CENTER;
    private int red = 255;
    private int green = 0;
    private int blue = 0;
    private int alpha = 70;
    private int thick = 8;
    ItemStackHandler inventory = new ItemStackHandler(4){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileLaser(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.LASER.get(), pos, state);
        this.needsRedstone = 0;
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.LASER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerLaser(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    BlockPos getPosTarget() {
        BlockPosDim loc = LocationGpsCard.getPosition(this.inventory.getStackInSlot(0));
        if (loc != null && loc.getPos() != null) {
            return loc.getPos();
        }
        return this.m_58899_();
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case THICK: {
                return this.thick;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case BLUE: {
                return this.blue;
            }
            case GREEN: {
                return this.green;
            }
            case RED: {
                return this.red;
            }
            case ALPHA: {
                return this.alpha;
            }
            case XOFF: {
                return this.xOffset.ordinal();
            }
            case YOFF: {
                return this.yOffset.ordinal();
            }
            case ZOFF: {
                return this.zOffset.ordinal();
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case THICK: {
                this.thick = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case BLUE: {
                this.blue = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case ALPHA: {
                this.alpha = value;
                break;
            }
            case XOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.xOffset = OffsetEnum.values()[value];
                break;
            }
            case YOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.yOffset = OffsetEnum.values()[value];
                break;
            }
            case ZOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.zOffset = OffsetEnum.values()[value];
            }
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.red = tag.m_128451_("red");
        this.green = tag.m_128451_("green");
        this.blue = tag.m_128451_("blue");
        this.alpha = tag.m_128451_("alpha");
        this.thick = tag.m_128451_("thick");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("red", this.red);
        tag.m_128405_("green", this.green);
        tag.m_128405_("blue", this.blue);
        tag.m_128405_("alpha", this.alpha);
        tag.m_128405_("thick", this.thick);
        super.m_183515_(tag);
    }

    public float getRed() {
        return (float)this.red / 255.0f;
    }

    public float getBlue() {
        return (float)this.blue / 255.0f;
    }

    public float getGreen() {
        return (float)this.green / 255.0f;
    }

    public float getAlpha() {
        float a = this.alpha;
        return a / 100.0f;
    }

    public float getThick() {
        float t = this.thick;
        return t / 100.0f;
    }

    static enum Fields {
        REDSTONE,
        THICK,
        RED,
        GREEN,
        BLUE,
        ALPHA,
        XOFF,
        YOFF,
        ZOFF;

    }
}

