/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.library.util.BlockstatesUtil;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class BlockEnderCtrl
extends BlockCyclic {
    public BlockEnderCtrl(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEnderCtrl(pos, state);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)BlockstatesUtil.getFacingFromEntityHorizontal((BlockPos)pos, (LivingEntity)entity)), 2);
            TileEnderCtrl ctrl = (TileEnderCtrl)world.m_7702_(pos);
            if (ctrl != null) {
                Set<BlockPos> shlf = EnderShelfHelper.findConnectedShelves(world, pos, ctrl.getCurrentFacing());
                ctrl.setAndSort(shlf);
            }
        }
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean isCurrentlyShelf = EnderShelfHelper.isShelf(state);
        boolean isNewShelf = EnderShelfHelper.isShelf(newState);
        TileEnderCtrl ctrl = (TileEnderCtrl)worldIn.m_7702_(pos);
        if (isCurrentlyShelf && !isNewShelf && ctrl != null) {
            ctrl.setAndSort(EnderShelfHelper.findConnectedShelves(worldIn, pos, ctrl.getCurrentFacing()));
        }
        if (state.m_60734_() != newState.m_60734_()) {
            worldIn.m_46747_(pos);
            worldIn.m_46717_(pos, (Block)this);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND && heldItem.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (heldItem.m_204117_(DataTags.WRENCH)) {
            TileEnderCtrl contrl = (TileEnderCtrl)world.m_7702_(pos);
            contrl.toggleShowText();
            TileEnderShelf.RenderTextType nt = contrl.renderStyle;
            for (BlockPos shelf : contrl.getShelves()) {
                BlockEntity shelfy = world.m_7702_(shelf);
                if (!(shelfy instanceof TileEnderShelf)) continue;
                ((TileEnderShelf)shelfy).renderStyle = nt;
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            return InteractionResult.PASS;
        }
        if (heldItem.m_41720_() == Items.f_42690_) {
            world.m_7702_(pos).getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> this.insertIntoController(player, hand, heldItem, (IItemHandler)h));
        }
        return InteractionResult.CONSUME;
    }

    private void insertIntoController(Player player, InteractionHand hand, ItemStack heldItem, IItemHandler controller) {
        Map allofthem = EnchantmentHelper.m_44831_((ItemStack)heldItem);
        if (allofthem == null || allofthem.size() == 0) {
            return;
        }
        if (allofthem.size() == 1) {
            ItemStack insertResult = controller.insertItem(0, heldItem, false);
            player.m_21008_(hand, insertResult);
        } else {
            Enchantment[] flatten;
            for (Enchantment entry : flatten = allofthem.keySet().toArray(new Enchantment[0])) {
                ItemStack fake = new ItemStack((ItemLike)Items.f_42690_);
                EnchantedBookItem.m_41153_((ItemStack)fake, (EnchantmentInstance)new EnchantmentInstance(entry, ((Integer)allofthem.get(entry)).intValue()));
                ItemStack insertResult = controller.insertItem(0, fake, false);
                if (!insertResult.m_41619_()) continue;
                allofthem.remove(entry);
            }
            if (allofthem.isEmpty()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            } else {
                ItemStack newFake = new ItemStack((ItemLike)Items.f_42690_);
                for (Enchantment newentry : allofthem.keySet()) {
                    EnchantedBookItem.m_41153_((ItemStack)newFake, (EnchantmentInstance)new EnchantmentInstance(newentry, ((Integer)allofthem.get(newentry)).intValue()));
                }
                player.m_21008_(hand, newFake);
            }
        }
    }
}

