/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.network.CMessagePlayerCapRemovePerk;
import ovh.corail.tombstone.network.CMessagePlayerCapSetPerk;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessageUpgradePerk(SyncType syncType, Perk perk) {
    static SMessageUpgradePerk fromBytes(FriendlyByteBuf buf) {
        return new SMessageUpgradePerk(buf.readBoolean() ? SyncType.DOWNGRADE_PERK : SyncType.UPGRADE_PERK, PerkRegistry.getValue(buf.m_130277_()));
    }

    static void toBytes(SMessageUpgradePerk msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.syncType == SyncType.DOWNGRADE_PERK);
        buf.m_130070_(PerkRegistry.getStringKey(msg.perk));
    }

    public static enum SyncType {
        UPGRADE_PERK,
        DOWNGRADE_PERK;

    }

    public static class Handler {
        static void handle(final SMessageUpgradePerk message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayer player = ctx.getSender();
                        if (player != null && !message.perk.isDisabled((Player)player)) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                                if (message2.syncType == SyncType.UPGRADE_PERK) {
                                    if (cap.canUpgradePerk((Player)player, message2.perk)) {
                                        int newPerklevel = cap.getPerkLevel((Player)player, message2.perk) + 1;
                                        cap.setPerk(message2.perk, newPerklevel);
                                        ModTriggers.SELECTED_PERKS.trigger(player);
                                        PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(message2.perk, newPerklevel), player);
                                    }
                                } else if (message2.syncType == SyncType.DOWNGRADE_PERK && cap.canDowngradePerk((Player)player, message2.perk)) {
                                    int newPerklevel = cap.getPerkLevel((Player)player, message2.perk) - 1;
                                    if (newPerklevel == 0) {
                                        cap.removePerk(message2.perk);
                                        PacketHandler.sendToPlayer(new CMessagePlayerCapRemovePerk(message2.perk), player);
                                    } else {
                                        cap.setPerk(message2.perk, newPerklevel);
                                        PacketHandler.sendToPlayer(new CMessagePlayerCapSetPerk(message2.perk, newPerklevel), player);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

