/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemSearchable;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemVillagerGift
extends ItemSearchable {
    public ItemVillagerGift() {
        super("villager_gift", () -> true);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.m_150930_((Item)this) && !TimeHelper.isDateAroundChristmas()) {
            stack.m_41774_(stack.m_41613_());
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
    }

    @Override
    protected void giveReward(ServerPlayer player, BlockPos targetPos) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
            cap.rewardKnowledge(player, 5);
            cap.rewardAlignment(player, 50);
        });
        player.m_6756_(500);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ModItems.receptacle_of_familiar.setRandomFamiliar(new ItemStack((ItemLike)ModItems.receptacle_of_familiar)));
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_familiar));
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.restoration));
        ItemStack tablet = ModItems.tablet_of_guard.createAncient();
        NBTStackHelper.setBoolean(tablet, "enchant", true);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)tablet);
        int random = Helper.RANDOM.nextInt(100);
        if (random < 10) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.essence_of_undeath));
        } else if (random < 30) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_guardian));
        } else if (random < 60) {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.gemstone_of_merchant));
        } else {
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.receptacle_of_soul));
        }
        LangKey.MESSAGE_VILLAGER_GIFT.sendMessage((Player)player, new Object[0]);
        ModTriggers.VILLAGER_GIFT.trigger(player);
    }

    @Override
    protected ResourceKey<PoiType> getTargetType() {
        return PoiTypes.f_218060_;
    }

    @Override
    protected Either<TagKey<Block>, Block> getTargetMatcher() {
        return Either.left((Object)BlockTags.f_13038_);
    }

    @Override
    protected Block getTargetForcedBlock() {
        return null;
    }

    @Override
    protected String getMessageToDisplay(Player player, ItemStack stack) {
        if (this.isInVillageRange(player, stack)) {
            if (this.isTargetFound(stack)) {
                return LangKey.MESSAGE_HIDE_GIFT.getText(new Object[0]).getString();
            }
            return LangKey.MESSAGE_FIND_BED.getText(new Object[0]).getString();
        }
        return LangKey.MESSAGE_FOLLOW_PARTICLES.getText(new Object[0]).getString();
    }
}

