/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private VoidType voidType;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount());
        this.filterLogic.setAllowByDefault(true);
        this.setFromLegacyComponent();
        this.setVoidOverflowDefaultOrLoadFromNbt(VoidType.ALWAYS);
    }

    private void setFromLegacyComponent() {
        if (NBTHelper.hasTag(this.upgrade, "shouldVoidOverflow")) {
            VoidType migratedVoidType = NBTHelper.getBoolean(this.upgrade, "shouldVoidOverflow").orElse(false) != false ? VoidType.ALWAYS : VoidType.SLOT_OVERFLOW;
            NBTHelper.removeTag(this.upgrade, "shouldVoidOverflow");
            this.setVoidType(migratedVoidType);
        }
    }

    @Override
    public ItemStack onBeforeInsert(InventoryHandler inventoryHandler, int slot, ItemStack stack, boolean simulate) {
        if (this.voidType == VoidType.SLOT_OVERFLOW && inventoryHandler.getStackInSlot(slot).m_41619_() && this.filterLogic.matchesFilter(stack)) {
            if (inventoryHandler.getSlotTracker().getFullStacks().contains(ItemStackKey.of(stack))) {
                return ItemStack.f_41583_;
            }
            return stack;
        }
        return this.voidType == VoidType.ALWAYS && this.filterLogic.matchesFilter(stack) ? ItemStack.f_41583_ : stack;
    }

    @Override
    public ItemStack onBeforeInsert(InventoryHandler inventoryHandler, ItemStack stack, boolean simulate) {
        return this.voidType == VoidType.ALWAYS && this.filterLogic.matchesFilter(stack) ? ItemStack.f_41583_ : stack;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        NBTHelper.setBoolean(this.upgrade, "shouldWorkInGUI", shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return NBTHelper.getBoolean(this.upgrade, "shouldWorkInGUI").orElse(false);
    }

    public void setVoidType(VoidType voidType) {
        if (voidType == VoidType.ALWAYS && !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled()) {
            return;
        }
        this.voidType = voidType;
        NBTHelper.setEnumConstant(this.upgrade, "voidType", voidType);
        this.save();
    }

    public void setVoidOverflowDefaultOrLoadFromNbt(VoidType voidOverflowDefault) {
        VoidType vt = NBTHelper.getEnumConstant(this.upgrade, "voidType", VoidType::fromName).orElse(voidOverflowDefault);
        if (!((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled() && vt == VoidType.ALWAYS) {
            vt = VoidType.SLOT_OVERFLOW;
        }
        this.voidType = vt;
    }

    public boolean shouldVoidOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled() || this.voidType != VoidType.ALWAYS;
    }

    public VoidType getVoidType() {
        if (this.voidType == VoidType.ALWAYS && !((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled()) {
            return VoidType.SLOT_OVERFLOW;
        }
        return this.voidType;
    }

    @Override
    public void onSlotChange(IItemHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.shouldVoidOverflow()) {
            return;
        }
        ItemStack slotStack = inventoryHandler.getStackInSlot(slot);
        if (this.filterLogic.matchesFilter(slotStack)) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable Entity entity, Level world, BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        for (int slot : this.slotsToVoid) {
            storageInventory.extractItem(slot, storageInventory.getStackInSlot(slot).m_41613_(), false);
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public ItemStack onSlotOverflow(ItemStack stack) {
        return this.voidType == VoidType.SLOT_OVERFLOW && this.filterLogic.matchesFilter(stack) ? ItemStack.f_41583_ : stack;
    }

    @Override
    public ItemStack onStorageOverflow(ItemStack stack) {
        return this.voidType == VoidType.STORAGE_OVERFLOW && this.filterLogic.matchesFilter(stack) ? ItemStack.f_41583_ : stack;
    }

    @Override
    public boolean stackMatchesFilter(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    public boolean isVoidAlwaysEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAlwaysEnabled();
    }
}

